/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors;

import fi.jumi.actors.ActorRef;
import fi.jumi.actors.ActorThread;
import fi.jumi.actors.MessageProcessor;
import fi.jumi.actors.eventizers.Event;
import fi.jumi.actors.eventizers.Eventizer;
import fi.jumi.actors.eventizers.EventizerProvider;
import fi.jumi.actors.listeners.FailureHandler;
import fi.jumi.actors.listeners.MessageListener;
import fi.jumi.actors.queue.MessageQueue;
import fi.jumi.actors.queue.MessageSender;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class Actors {
    private final EventizerProvider eventizerProvider;
    private final FailureHandler failureHandler;
    private final MessageListener messageListener;

    protected Actors(EventizerProvider eventizerProvider, FailureHandler failureHandler, MessageListener messageListener) {
        this.eventizerProvider = eventizerProvider;
        this.failureHandler = failureHandler;
        this.messageListener = messageListener;
    }

    public ActorThread startActorThread() {
        ActorThreadImpl actorThread = new ActorThreadImpl();
        this.startActorThread(actorThread);
        return actorThread;
    }

    abstract void startActorThread(MessageProcessor var1);

    @Immutable
    private static class PoisonPill
    implements Runnable {
        private PoisonPill() {
        }

        @Override
        public void run() {
            Thread.currentThread().interrupt();
        }
    }

    @NotThreadSafe
    private class MessageToActor<T>
    implements Runnable {
        private final T rawActor;
        private final Event<T> message;

        public MessageToActor(T rawActor, Event<T> message) {
            this.rawActor = rawActor;
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Actors.this.messageListener.onProcessingStarted(this.rawActor, this.message);
            try {
                this.message.fireOn(this.rawActor);
            }
            catch (Throwable t) {
                Actors.this.failureHandler.uncaughtException(this.rawActor, this.message, t);
            }
            finally {
                Actors.this.messageListener.onProcessingFinished();
            }
        }
    }

    @ThreadSafe
    private class MessageToActorSender<T>
    implements MessageSender<Event<T>> {
        private final ActorThreadImpl actorThread;
        private final T rawActor;

        public MessageToActorSender(ActorThreadImpl actorThread, T rawActor) {
            this.actorThread = actorThread;
            this.rawActor = rawActor;
        }

        @Override
        public void send(Event<T> message) {
            Actors.this.messageListener.onMessageSent(message);
            this.actorThread.send(new MessageToActor<T>(this.rawActor, message));
        }
    }

    @ThreadSafe
    private class ActorThreadImpl
    implements ActorThread,
    MessageProcessor {
        private final MessageQueue<Runnable> taskQueue = new MessageQueue();

        private ActorThreadImpl() {
        }

        @Override
        public <T> ActorRef<T> bindActor(Class<T> type, T rawActor) {
            Eventizer<T> eventizer = Actors.this.eventizerProvider.getEventizerForType(type);
            T proxy = eventizer.newFrontend(new MessageToActorSender<T>(this, rawActor));
            return ActorRef.wrap(type.cast(proxy));
        }

        @Override
        public void stop() {
            this.taskQueue.send(new PoisonPill());
        }

        public void send(MessageToActor<?> task) {
            this.taskQueue.send(task);
        }

        @Override
        public void processNextMessage() throws InterruptedException {
            Runnable task = this.taskQueue.take();
            this.process(task);
        }

        @Override
        public boolean processNextMessageIfAny() {
            Runnable task = this.taskQueue.poll();
            if (task == null) {
                return false;
            }
            this.process(task);
            return true;
        }

        private void process(Runnable task) {
            task.run();
        }
    }
}

