/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors;

import fi.jumi.actors.Actors;
import fi.jumi.actors.MessageProcessor;
import fi.jumi.actors.eventizers.EventizerProvider;
import fi.jumi.actors.listeners.FailureHandler;
import fi.jumi.actors.listeners.MessageListener;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MultiThreadedActors
extends Actors {
    private final Executor executor;

    public MultiThreadedActors(Executor executor, EventizerProvider eventizerProvider, FailureHandler failureHandler, MessageListener messageListener) {
        super(eventizerProvider, failureHandler, messageListener);
        this.executor = executor;
    }

    @Override
    void startActorThread(MessageProcessor actorThread) {
        this.executor.execute(new BlockingActorProcessor(actorThread));
    }

    @ThreadSafe
    private static class BlockingActorProcessor
    implements Runnable {
        private final MessageProcessor actorThread;

        public BlockingActorProcessor(MessageProcessor actorThread) {
            this.actorThread = actorThread;
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    this.actorThread.processNextMessage();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

