/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors;

import fi.jumi.actors.ActorRef;
import fi.jumi.actors.ActorThread;
import fi.jumi.actors.Actors;
import fi.jumi.actors.MessageProcessor;
import fi.jumi.actors.eventizers.EventizerProvider;
import fi.jumi.actors.listeners.FailureHandler;
import fi.jumi.actors.listeners.MessageListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
public class SingleThreadedActors
extends Actors {
    private final List<MessageProcessor> actorThreads = new CopyOnWriteArrayList<MessageProcessor>();
    private final MessageListener messageListener;

    public SingleThreadedActors(EventizerProvider eventizerProvider, FailureHandler failureHandler, MessageListener messageListener) {
        super(eventizerProvider, failureHandler, messageListener);
        this.messageListener = messageListener;
    }

    @Override
    void startActorThread(MessageProcessor actorThread) {
        this.actorThreads.add(actorThread);
    }

    public void processEventsUntilIdle() {
        boolean idle;
        do {
            idle = true;
            for (MessageProcessor actorThread : this.actorThreads) {
                if (actorThread.processNextMessageIfAny()) {
                    idle = false;
                }
                if (!Thread.interrupted()) continue;
                this.actorThreads.remove(actorThread);
            }
        } while (!idle);
    }

    public Executor getExecutor() {
        return this.messageListener.getListenedExecutor(new AsynchronousExecutor());
    }

    @ThreadSafe
    private class AsynchronousExecutor
    implements Executor {
        private AsynchronousExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            ActorThread actorThread = SingleThreadedActors.this.startActorThread();
            ActorRef<Runnable> actor = actorThread.bindActor(Runnable.class, command);
            actor.tell().run();
            actorThread.stop();
        }
    }
}

