/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors.eventizers;

import fi.jumi.actors.eventizers.Eventizer;
import fi.jumi.actors.eventizers.EventizerProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ComposedEventizerProvider
implements EventizerProvider {
    private final Map<Class<?>, Eventizer<?>> eventizers;

    public ComposedEventizerProvider(Eventizer<?> ... eventizers) {
        HashMap map = new HashMap();
        for (Eventizer<?> eventizer : eventizers) {
            map.put(eventizer.getType(), eventizer);
        }
        this.eventizers = Collections.unmodifiableMap(map);
    }

    @Override
    public <T> Eventizer<T> getEventizerForType(Class<T> type) {
        Eventizer<?> eventizer = this.eventizers.get(type);
        if (eventizer == null) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        return eventizer;
    }
}

