/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors.eventizers;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class EventToString {
    private final CharsetEncoder charsetEncoder;
    private final StringBuilder result = new StringBuilder();

    public EventToString(Charset charset) {
        this.charsetEncoder = charset.newEncoder();
    }

    public static String format(String className, String methodName, Object ... args) {
        return new EventToString(Charset.defaultCharset()).formatMethodCall(className, methodName, args).build();
    }

    public String build() {
        return this.result.toString();
    }

    public EventToString formatMethodCall(String className, String methodName, Object ... args) {
        this.result.append(className);
        this.result.append('.');
        this.result.append(methodName);
        this.result.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                this.result.append(", ");
            }
            this.formatArg(args[i]);
        }
        this.result.append(')');
        return this;
    }

    private void formatArg(Object arg) {
        if (arg instanceof String) {
            this.result.append('\"');
            this.escapeSpecialChars((String)arg);
            this.result.append('\"');
        } else {
            this.result.append(arg);
        }
    }

    EventToString escapeSpecialChars(String arg) {
        for (int i = 0; i < arg.length(); ++i) {
            this.escapeSpecialChar(arg.charAt(i));
        }
        return this;
    }

    private void escapeSpecialChar(char ch) {
        switch (ch) {
            case '\b': {
                this.result.append("\\b");
                return;
            }
            case '\t': {
                this.result.append("\\t");
                return;
            }
            case '\n': {
                this.result.append("\\n");
                return;
            }
            case '\f': {
                this.result.append("\\f");
                return;
            }
            case '\r': {
                this.result.append("\\r");
                return;
            }
            case '\"': {
                this.result.append("\\\"");
                return;
            }
            case '\\': {
                this.result.append("\\\\");
                return;
            }
        }
        if (Character.isISOControl(ch) || this.isUnmappable(ch)) {
            String mask = "\\u0000";
            String hex = Integer.toHexString(ch);
            this.result.append(mask, 0, mask.length() - hex.length());
            this.result.append(hex);
        } else {
            this.result.append(ch);
        }
    }

    private boolean isUnmappable(char ch) {
        return !this.charsetEncoder.canEncode(ch);
    }
}

