/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors.eventizers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Eventizers {
    private Eventizers() {
    }

    public static void validateActorInterface(Class<?> type) {
        Eventizers.checkIsInterface(type);
        for (Method method : type.getMethods()) {
            Eventizers.checkReturnTypeIsVoid(type, method);
            Eventizers.checkDoesNotThrowExceptions(type, method);
        }
    }

    private static void checkIsInterface(Class<?> type) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("actor interfaces must be interfaces, but got " + type);
        }
    }

    private static void checkReturnTypeIsVoid(Class<?> type, Method method) {
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            throw new IllegalArgumentException("actor interface methods must be void, but method " + method.getName() + " of " + type + " had return type " + returnType.getName());
        }
    }

    private static void checkDoesNotThrowExceptions(Class<?> type, Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            throw new IllegalArgumentException("actor interface methods may not throw exceptions, but method " + method.getName() + " of " + type + " throws " + Eventizers.format(exceptionTypes));
        }
    }

    private static String format(Class<?>[] types) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> type : types) {
            names.add(type.getName());
        }
        String s = ((Object)names).toString();
        return s.substring(1, s.length() - 1);
    }
}

