/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors.eventizers.dynamic;

import fi.jumi.actors.eventizers.Event;
import fi.jumi.actors.eventizers.EventToString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DynamicEvent<T>
implements Event<T>,
Serializable {
    private transient Method method;
    private final Object[] args;

    public DynamicEvent(Method method, Object[] args) {
        this.method = method;
        this.args = args;
    }

    @Override
    public void fireOn(T target) {
        try {
            this.method.invoke(target, this.args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.method.getName());
        out.writeObject(this.method.getDeclaringClass());
        out.writeObject(this.method.getParameterTypes());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String name = (String)in.readObject();
        Class declaringClass = (Class)in.readObject();
        Class[] parameterTypes = (Class[])in.readObject();
        try {
            this.method = declaringClass.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return EventToString.format(this.method.getDeclaringClass().getSimpleName(), this.method.getName(), DynamicEvent.nonNull(this.args));
    }

    private static Object[] nonNull(Object[] args) {
        if (args == null) {
            return new Object[0];
        }
        return args;
    }
}

