/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors.eventizers.dynamic;

import fi.jumi.actors.eventizers.Event;
import fi.jumi.actors.eventizers.Eventizer;
import fi.jumi.actors.eventizers.Eventizers;
import fi.jumi.actors.eventizers.dynamic.DynamicListenerToEvent;
import fi.jumi.actors.eventizers.dynamic.EventToDynamicListener;
import fi.jumi.actors.queue.MessageSender;
import java.lang.reflect.Proxy;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DynamicEventizer<T>
implements Eventizer<T> {
    private final Class<T> type;

    public DynamicEventizer(Class<T> type) {
        Eventizers.validateActorInterface(type);
        this.type = type;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T newFrontend(MessageSender<Event<T>> target) {
        return this.type.cast(Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, new DynamicListenerToEvent<T>(target)));
    }

    @Override
    public MessageSender<Event<T>> newBackend(T target) {
        return new EventToDynamicListener<T>(target);
    }
}

