/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors.eventizers.dynamic;

import fi.jumi.actors.eventizers.Eventizer;
import fi.jumi.actors.eventizers.EventizerProvider;
import fi.jumi.actors.eventizers.dynamic.DynamicEventizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DynamicEventizerProvider
implements EventizerProvider {
    private final ConcurrentHashMap<Class<?>, Eventizer<?>> cache = new ConcurrentHashMap();

    @Override
    public <T> Eventizer<T> getEventizerForType(Class<T> type) {
        Eventizer<?> eventizer = this.cache.get(type);
        if (eventizer == null) {
            eventizer = new DynamicEventizer(type);
            this.cache.put(type, eventizer);
        }
        return eventizer;
    }
}

