/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors.listeners;

import fi.jumi.actors.listeners.MessageListener;
import java.io.PrintStream;
import java.util.Locale;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PrintStreamMessageLogger
implements MessageListener {
    private static final String OUTGOING_MESSAGE = "->";
    private static final String INCOMING_MESSAGE = "<-";
    private final PrintStream out;
    private final ThreadLocal<Object> currentActor = new ThreadLocal();
    private final long startTime;

    public PrintStreamMessageLogger(PrintStream out) {
        this.out = out;
        this.startTime = this.nanoTime();
    }

    @Override
    public void onMessageSent(Object message) {
        this.logMessage(OUTGOING_MESSAGE, message);
    }

    @Override
    public void onProcessingStarted(Object actor, Object message) {
        this.currentActor.set(actor);
        this.logMessage(INCOMING_MESSAGE, message);
    }

    private void logMessage(String messageDirection, Object message) {
        String threadName = Thread.currentThread().getName();
        int messageId = System.identityHashCode(message);
        this.out.println(String.format(Locale.ENGLISH, "[%11.6f] [%s] %s %s 0x%08x %s", this.secondsSinceStart(), threadName, this.currentActorFormatted(), messageDirection, messageId, message));
    }

    private double secondsSinceStart() {
        long nanosSinceStart = this.nanoTime() - this.startTime;
        return (double)nanosSinceStart / 1.0E9;
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    private String currentActorFormatted() {
        Object currentActor = this.currentActor.get();
        if (currentActor == null) {
            return "<external>";
        }
        return currentActor.toString();
    }

    @Override
    public void onProcessingFinished() {
        this.currentActor.remove();
    }

    @Override
    public Executor getListenedExecutor(Executor realExecutor) {
        return new LoggedExecutor(realExecutor);
    }

    @ThreadSafe
    private class LoggedRunnable
    implements Runnable {
        private final Executor realExecutor;
        private final Runnable realCommand;

        public LoggedRunnable(Executor realExecutor, Runnable realCommand) {
            this.realExecutor = realExecutor;
            this.realCommand = realCommand;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PrintStreamMessageLogger.this.onProcessingStarted(this.realExecutor, this.realCommand);
            try {
                this.realCommand.run();
            }
            finally {
                PrintStreamMessageLogger.this.onProcessingFinished();
            }
        }
    }

    @ThreadSafe
    private class LoggedExecutor
    implements Executor {
        private final Executor realExecutor;

        public LoggedExecutor(Executor realExecutor) {
            this.realExecutor = realExecutor;
        }

        @Override
        public void execute(Runnable realCommand) {
            PrintStreamMessageLogger.this.onMessageSent(realCommand);
            this.realExecutor.execute(new LoggedRunnable(this.realExecutor, realCommand));
        }
    }
}

