/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.actors.workers;

import fi.jumi.actors.ActorRef;
import fi.jumi.actors.workers.WorkerListener;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WorkerCounter
implements Executor {
    private final Executor realExecutor;
    private final AtomicInteger activeWorkers = new AtomicInteger(0);
    @GuardedBy(value="this")
    private ActorRef<WorkerListener> onFinished;

    public WorkerCounter(Executor realExecutor) {
        this.realExecutor = realExecutor;
    }

    @Override
    public void execute(Runnable command) {
        this.realExecutor.execute(new Worker(command));
    }

    public synchronized void afterPreviousWorkersFinished(ActorRef<WorkerListener> onFinished) {
        if (this.onFinished != null) {
            throw new IllegalStateException("a callback already exists; wait for the workers to finish before setting a new callback");
        }
        this.onFinished = onFinished;
        if (this.activeWorkers.get() == 0) {
            this.fireAllWorkersFinished();
        }
    }

    private synchronized void fireAllWorkersFinished() {
        if (this.onFinished != null) {
            this.onFinished.tell().onAllWorkersFinished();
            this.onFinished = null;
        }
    }

    private void fireWorkerCreated() {
        this.activeWorkers.incrementAndGet();
    }

    private void fireWorkerFinished() {
        int workers = this.activeWorkers.decrementAndGet();
        if (workers == 0) {
            this.fireAllWorkersFinished();
        }
    }

    @ThreadSafe
    private class Worker
    implements Runnable {
        private final Runnable command;

        public Worker(Runnable command) {
            WorkerCounter.this.fireWorkerCreated();
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.command.run();
            }
            finally {
                WorkerCounter.this.fireWorkerFinished();
            }
        }

        public String toString() {
            return this.command.toString();
        }
    }
}

