/*
 * Decompiled with CFR 0.152.
 */
package fi.nationallibrary.mauiservice;

import com.entopix.maui.filters.MauiFilter;
import fi.nationallibrary.mauiservice.AnalysisParameterFactory;
import fi.nationallibrary.mauiservice.AnalysisParameters;
import fi.nationallibrary.mauiservice.Analyzer;
import fi.nationallibrary.mauiservice.maui.MauiFilters;
import fi.nationallibrary.mauiservice.response.AnalyzerResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class AnalyzeController {
    private Logger logger = LoggerFactory.getLogger(AnalyzeController.class);
    @Autowired
    private MauiFilters filters;
    @Autowired
    private Analyzer analyzer;
    @Autowired
    private AnalysisParameterFactory analysisParameterFactory;

    @RequestMapping(path={"/"}, method={RequestMethod.GET})
    public Set<String> index() {
        return this.filters.getFilterNames();
    }

    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public Set<String> indexForId(@PathVariable(value="id") String configurationId, HttpServletResponse httpResponse) {
        MauiFilter filter = this.filters.getFilter(configurationId);
        if (filter == null) {
            httpResponse.setStatus(404);
            return null;
        }
        return Collections.singleton("analyze");
    }

    @RequestMapping(path={"/{id}/analyze"}, consumes={"application/json"}, method={RequestMethod.POST})
    public AnalyzerResponse analyzeJSON(@PathVariable(value="id") String configurationId, @RequestBody Map<String, Object> parameters, HttpServletResponse response) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Received JSON analysis request for id '" + configurationId + "' with text '" + parameters.get("text") + "'");
        }
        String text = (String)parameters.get("text");
        AnalysisParameters p = this.analysisParameterFactory.createParameters(parameters.get("parameters"));
        return this.processRequest(configurationId, response, text, p);
    }

    @RequestMapping(path={"/{id}/analyze"}, consumes={"application/x-www-form-urlencoded"}, method={RequestMethod.POST})
    public AnalyzerResponse analyzeFormEncoded(@PathVariable(value="id") String configurationId, @RequestBody MultiValueMap<String, Object> parameters, HttpServletResponse response) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Received FORM analysis request for id '" + configurationId + "' with text '" + parameters.getFirst((Object)"text") + "'");
        }
        String text = (String)parameters.getFirst((Object)"text");
        HashMap<String, Object> extraParameters = new HashMap<String, Object>();
        for (String key : parameters.keySet()) {
            if (key.indexOf("parameters.") != 0) continue;
            extraParameters.put(key.substring(11), parameters.getFirst((Object)key));
        }
        AnalysisParameters p = this.analysisParameterFactory.createParameters(extraParameters);
        return this.processRequest(configurationId, response, text, p);
    }

    @RequestMapping(path={"/{id}/analyze"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public AnalyzerResponse analyzeMultipart(@PathVariable(value="id") String configurationId, @RequestParam(value="text") MultipartFile textFile, @RequestParam(value="charset") String charset, @RequestParam MultiValueMap<String, Object> parameters, HttpServletResponse response) {
        String text;
        if (charset == null) {
            charset = "UTF-8";
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Received a multipart analysis request for id '" + configurationId + "', file character set is " + charset);
        }
        try {
            text = new String(textFile.getBytes(), charset);
        }
        catch (IOException ie) {
            throw new IllegalArgumentException(ie);
        }
        AnalysisParameters p = this.analysisParameterFactory.createParameters(parameters);
        return this.processRequest(configurationId, response, text, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnalyzerResponse processRequest(String configurationId, HttpServletResponse httpResponse, String text, AnalysisParameters p) {
        AnalyzerResponse response;
        MauiFilter filter = this.filters.getFilter(configurationId);
        if (filter == null) {
            httpResponse.setStatus(404);
            return null;
        }
        MauiFilter mauiFilter = filter;
        synchronized (mauiFilter) {
            response = this.analyzer.analyze(filter, text);
        }
        this.sortResults(response);
        if (p.getLimitNumberOfResults() != null) {
            this.limitResults(response, p.getLimitNumberOfResults());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(" - analysis result: '" + response + "'");
        }
        return response;
    }

    void sortResults(AnalyzerResponse response) {
        Collections.sort(response.getResults(), new /* Unavailable Anonymous Inner Class!! */);
    }

    void limitResults(AnalyzerResponse response, Integer limitNumberOfResults) {
        List tmp = response.getResults();
        if (tmp.size() > limitNumberOfResults) {
            tmp = tmp.subList(0, limitNumberOfResults);
            response.setResults(tmp);
        }
    }
}

