/*
 * Decompiled with CFR 0.152.
 */
package fi.nationallibrary.mauiservice;

import com.entopix.maui.filters.MauiFilter;
import fi.nationallibrary.mauiservice.response.AnalyzerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class Analyzer {
    private static Logger logger = LoggerFactory.getLogger(Analyzer.class);

    public AnalyzerResponse analyze(MauiFilter filter, String input) {
        Instance inst;
        FastVector atts = new FastVector(3);
        atts.addElement((Object)new Attribute("filename", (FastVector)null));
        atts.addElement((Object)new Attribute("doc", (FastVector)null));
        atts.addElement((Object)new Attribute("keyphrases", (FastVector)null));
        Instances data = new Instances("keyphrase_training_data", atts, 0);
        double[] newInst = new double[]{Instance.missingValue(), data.attribute(1).addStringValue(input), Instance.missingValue()};
        data.add(new Instance(1.0, newInst));
        try {
            filter.input(data.instance(0));
        }
        catch (MauiFilter.MauiFilterException mfe) {
            throw new IllegalArgumentException("Unable to process data", mfe);
        }
        data = data.stringFreeStructure();
        logger.trace("-- Keyphrases and feature values:");
        AnalyzerResponse response = new AnalyzerResponse();
        while ((inst = filter.output()) != null) {
            String uri = inst.stringValue(0);
            double score = inst.value(filter.getProbabilityIndex());
            String label = inst.stringValue(filter.getOutputFormIndex());
            AnalyzerResponse.AnalyzerResult result = new AnalyzerResponse.AnalyzerResult();
            result.setUri(uri);
            result.setScore(Double.valueOf(score));
            result.setLabel(label);
            if (logger.isTraceEnabled()) {
                logger.trace(" - result " + result.getUri() + " (" + result.getLabel() + "), score = " + result.getScore());
            }
            response.getResults().add(result);
        }
        return response;
    }
}

