/*
 * Decompiled with CFR 0.152.
 */
package fi.nationallibrary.mauiservice.ini;

import fi.nationallibrary.mauiservice.ini.MauiConfiguration;
import fi.nationallibrary.mauiservice.ini.MauiConfigurationFactory;
import fi.nationallibrary.mauiservice.ini.MauiFilterConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.ini4j.Wini;

public class INI4JMauiConfigurationFactoryImpl
implements MauiConfigurationFactory {
    public MauiConfiguration readConfig(File configurationPath, Reader reader) throws IOException {
        try {
            Wini ini = new Wini(reader);
            MauiConfiguration ret = new MauiConfiguration();
            for (Map.Entry e : ini.entrySet()) {
                MauiFilterConfiguration mmc = new MauiFilterConfiguration();
                ret.getConfigurations().put(e.getKey(), mmc);
                mmc.setLanguage(this.getFieldOrFail(e, "language"));
                mmc.setModel(this.getFieldOrFail(e, "model"));
                mmc.setStemmer(this.getFieldOrFail(e, "stemmer"));
                mmc.setStopwords(this.getFieldOrFail(e, "stopwords"));
                mmc.setVocab(this.getFieldOrFail(e, "vocab"));
                mmc.setVocabFormat(this.getFieldOrFail(e, "vocabformat"));
                mmc.setConfigurationDirectory(configurationPath);
            }
            return ret;
        }
        catch (InvalidFileFormatException e) {
            throw new IOException(e);
        }
    }

    private String getFieldOrFail(Map.Entry<String, Profile.Section> e, String key) throws IOException {
        String value = (String)e.getValue().get((Object)key);
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.length() == 0) {
            throw new IOException("Section " + e.getKey() + " is missing value for " + key);
        }
        return value;
    }
}

