/*
 * Decompiled with CFR 0.152.
 */
package fi.nationallibrary.mauiservice.maui;

import com.entopix.maui.filters.MauiFilter;
import com.entopix.maui.stemmers.Stemmer;
import com.entopix.maui.stopwords.Stopwords;
import com.entopix.maui.vocab.Vocabulary;
import fi.nationallibrary.mauiservice.ini.MauiFilterConfiguration;
import fi.nationallibrary.mauiservice.maui.MauiFilterFactory;
import fi.nationallibrary.mauiservice.maui.MauiFilterInitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class MauiFilterFactoryImpl
implements MauiFilterFactory {
    public MauiFilter createFilter(MauiFilterConfiguration config) throws MauiFilterInitializationException {
        MauiFilter ret;
        File modelFile = MauiFilterFactoryImpl.getFilePossiblyInRelativePath((File)config.getConfigurationDirectory(), (String)config.getModel());
        File vocabFile = MauiFilterFactoryImpl.getFilePossiblyInRelativePath((File)config.getConfigurationDirectory(), (String)config.getVocab());
        this.testFile("Model", modelFile);
        this.testFile("Vocabulary", vocabFile);
        try (FileInputStream is = new FileInputStream(modelFile);){
            ObjectInputStream in = new ObjectInputStream(is);
            ret = (MauiFilter)in.readObject();
        }
        catch (IOException e) {
            throw new MauiFilterInitializationException("Error while loading extraction model from file " + config.getModel() + "!\n", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MauiFilterInitializationException("Class mismatch when loading maui model from file " + config.getModel() + "!\n", (Throwable)e);
        }
        ret.setVocabularyName(config.getVocab());
        ret.setVocabularyFormat(config.getVocabFormat());
        ret.setDocumentLanguage(config.getLanguage());
        Vocabulary vocabulary = new Vocabulary();
        try {
            String stemmerString = "com.entopix.maui.stemmers.".concat(config.getStemmer());
            Stemmer stemmer = (Stemmer)Class.forName(stemmerString).newInstance();
            ret.setStemmer(stemmer);
            vocabulary.setStemmer(stemmer);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MauiFilterInitializationException("Unable to load stemmer " + config.getStemmer(), (Throwable)e);
        }
        try {
            String stopwordsString = "com.entopix.maui.stopwords.".concat(config.getStopwords());
            Stopwords stopwords = (Stopwords)Class.forName(stopwordsString).newInstance();
            vocabulary.setStopwords(stopwords);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MauiFilterInitializationException("Unable to load stopwords " + config.getStopwords(), (Throwable)e);
        }
        vocabulary.setLanguage(config.getLanguage());
        vocabulary.setSerialize(false);
        vocabulary.initializeVocabulary(vocabFile.getAbsolutePath(), config.getVocabFormat());
        ret.setVocabulary(vocabulary);
        return ret;
    }

    static File getFilePossiblyInRelativePath(File path, String relativeOrAbsolute) {
        if (relativeOrAbsolute.startsWith("/")) {
            return new File(relativeOrAbsolute);
        }
        return new File(path, relativeOrAbsolute);
    }

    private void testFile(String type, File file) throws MauiFilterInitializationException {
        if (!file.exists()) {
            throw new MauiFilterInitializationException(type + " file " + file + " does not exist!");
        }
        if (file.isDirectory()) {
            throw new MauiFilterInitializationException(type + " file " + file + " is a directory, expecting a file!");
        }
        if (!file.canRead()) {
            throw new MauiFilterInitializationException("Cannot read " + type + " file " + file + "!");
        }
    }
}

