/*
 * Decompiled with CFR 0.152.
 */
package fi.nationallibrary.mauiservice.maui;

import com.entopix.maui.filters.MauiFilter;
import fi.nationallibrary.mauiservice.ini.MauiConfiguration;
import fi.nationallibrary.mauiservice.ini.MauiFilterConfiguration;
import fi.nationallibrary.mauiservice.maui.MauiFilterFactory;
import fi.nationallibrary.mauiservice.maui.MauiFilterInitializationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MauiFilters {
    private static Logger logger = LoggerFactory.getLogger(MauiFilters.class);
    private MauiFilterFactory filterFactory;
    private MauiConfiguration configuration;
    private Map<String, MauiFilter> filters;

    public MauiFilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public void setFilterFactory(MauiFilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public MauiConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MauiConfiguration configuration) {
        this.configuration = configuration;
    }

    public MauiFilter getFilter(String id) {
        if (this.filters == null) {
            throw new IllegalStateException("Call init() before getFilter()");
        }
        return (MauiFilter)this.filters.get(id);
    }

    public Set<String> getFilterNames() {
        return Collections.unmodifiableSet(this.filters.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws MauiFilterInitializationException {
        if (this.filters == null) {
            MauiFilters mauiFilters = this;
            synchronized (mauiFilters) {
                if (this.filters == null) {
                    this.filters = this.createFilters();
                }
            }
        }
    }

    private Map<String, MauiFilter> createFilters() throws MauiFilterInitializationException {
        HashMap<String, MauiFilter> ret = new HashMap<String, MauiFilter>();
        for (Map.Entry e : this.getConfiguration().getConfigurations().entrySet()) {
            logger.info("Creating MauiFilter " + (String)e.getKey());
            MauiFilter tmp = this.getFilterFactory().createFilter((MauiFilterConfiguration)e.getValue());
            ret.put((String)e.getKey(), tmp);
        }
        return ret;
    }
}

