/*
 * Decompiled with CFR 0.152.
 */
package fi.nationallibrary.mauiservice.maui;

import com.entopix.maui.filters.MauiFilter;
import com.entopix.maui.stemmers.Stemmer;
import com.entopix.maui.stopwords.Stopwords;
import com.entopix.maui.vocab.Vocabulary;
import fi.nationallibrary.mauiservice.ini.MauiFilterConfiguration;
import fi.nationallibrary.mauiservice.maui.MauiFilterFactory;
import fi.nationallibrary.mauiservice.maui.MauiFilterFactoryImpl;
import fi.nationallibrary.mauiservice.maui.MauiFilterInitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedVocabularyMauiFilterFactoryImpl
implements MauiFilterFactory {
    private static Logger logger = LoggerFactory.getLogger(SharedVocabularyMauiFilterFactoryImpl.class);
    private Map<String, Vocabulary> vocabularyCache = new HashMap();

    public MauiFilter createFilter(MauiFilterConfiguration config) throws MauiFilterInitializationException {
        File modelFile = MauiFilterFactoryImpl.getFilePossiblyInRelativePath((File)config.getConfigurationDirectory(), (String)config.getModel());
        File vocabFile = MauiFilterFactoryImpl.getFilePossiblyInRelativePath((File)config.getConfigurationDirectory(), (String)config.getVocab());
        this.testFile("Model", modelFile);
        this.testFile("Vocabulary", vocabFile);
        MauiFilter ret = this.readModel(config, modelFile);
        ret.setVocabularyName(config.getVocab());
        ret.setVocabularyFormat(config.getVocabFormat());
        ret.setDocumentLanguage(config.getLanguage());
        boolean cachedVocabulary = false;
        Vocabulary vocabulary = this.getCachedVocabulary(vocabFile, config.getStemmer(), config.getStopwords(), config.getLanguage());
        if (vocabulary != null) {
            logger.info("Using previously cached vocabulary " + vocabFile + " (stemmer: " + config.getStemmer() + ", stopwords: " + config.getStopwords() + ", language: " + config.getLanguage() + ")");
            cachedVocabulary = true;
        }
        Stemmer stemmer = this.loadStemmer(config);
        ret.setStemmer(stemmer);
        if (!cachedVocabulary) {
            vocabulary = this.createVocabulary(config, vocabFile, stemmer);
            logger.info("Caching vocabulary " + vocabFile + " (stemmer: " + config.getStemmer() + ", stopwords: " + config.getStopwords() + ", language: " + config.getLanguage() + ")");
            this.cacheVocabulary(vocabFile, config.getStemmer(), config.getStopwords(), config.getLanguage(), vocabulary);
        }
        ret.setVocabulary(vocabulary);
        return ret;
    }

    private String createVocabularyKey(File file, String stemmerName, String stopWords, String language) throws MauiFilterInitializationException {
        try {
            return file.getCanonicalPath() + "///" + stemmerName + "///" + stopWords + "///" + language;
        }
        catch (IOException ie) {
            throw new MauiFilterInitializationException("Cannot determine canonical file name for vocabulary", (Throwable)ie);
        }
    }

    Vocabulary getCachedVocabulary(File file, String stemmerName, String stopWords, String language) throws MauiFilterInitializationException {
        String key = this.createVocabularyKey(file, stemmerName, stopWords, language);
        return (Vocabulary)this.vocabularyCache.get(key);
    }

    void cacheVocabulary(File file, String stemmerName, String stopWords, String language, Vocabulary vocabulary) throws MauiFilterInitializationException {
        String key = this.createVocabularyKey(file, stemmerName, stopWords, language);
        this.vocabularyCache.put(key, vocabulary);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MauiFilter readModel(MauiFilterConfiguration config, File modelFile) throws MauiFilterInitializationException {
        try (FileInputStream is = new FileInputStream(modelFile);){
            ObjectInputStream in = new ObjectInputStream(is);
            MauiFilter mauiFilter = (MauiFilter)in.readObject();
            return mauiFilter;
        }
        catch (IOException e) {
            throw new MauiFilterInitializationException("Error while loading extraction model from file " + config.getModel() + "!\n", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MauiFilterInitializationException("Class mismatch when loading maui model from file " + config.getModel() + "!\n", (Throwable)e);
        }
    }

    Vocabulary createVocabulary(MauiFilterConfiguration config, File vocabFile, Stemmer stemmer) throws MauiFilterInitializationException {
        Vocabulary vocabulary = new Vocabulary();
        vocabulary.setStemmer(stemmer);
        try {
            String stopwordsString = "com.entopix.maui.stopwords.".concat(config.getStopwords());
            Stopwords stopwords = (Stopwords)Class.forName(stopwordsString).newInstance();
            vocabulary.setStopwords(stopwords);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MauiFilterInitializationException("Unable to load stopwords " + config.getStopwords(), (Throwable)e);
        }
        vocabulary.setLanguage(config.getLanguage());
        vocabulary.setSerialize(false);
        vocabulary.initializeVocabulary(vocabFile.getAbsolutePath(), config.getVocabFormat());
        return vocabulary;
    }

    Stemmer loadStemmer(MauiFilterConfiguration config) throws MauiFilterInitializationException {
        try {
            String stemmerString = "com.entopix.maui.stemmers.".concat(config.getStemmer());
            return (Stemmer)Class.forName(stemmerString).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MauiFilterInitializationException("Unable to load stemmer " + config.getStemmer(), (Throwable)e);
        }
    }

    void testFile(String type, File file) throws MauiFilterInitializationException {
        if (!file.exists()) {
            throw new MauiFilterInitializationException(type + " file " + file + " does not exist!");
        }
        if (file.isDirectory()) {
            throw new MauiFilterInitializationException(type + " file " + file + " is a directory, expecting a file!");
        }
        if (!file.canRead()) {
            throw new MauiFilterInitializationException("Cannot read " + type + " file " + file + "!");
        }
    }
}

