/*
 * Decompiled with CFR 0.152.
 */
package fi.protonode.certy;

import fi.protonode.certy.Credential;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateRevocationList {
    private Credential issuer;
    private List<Credential> revoked = new ArrayList<Credential>();
    private Date thisUpdate;
    private Date nextUpdate;

    public CertificateRevocationList thisUpdate(Date val) {
        this.thisUpdate = val;
        return this;
    }

    public CertificateRevocationList nextUpdate(Date val) {
        this.nextUpdate = val;
        return this;
    }

    public CertificateRevocationList issuer(Credential val) {
        this.issuer = val;
        return this;
    }

    public CertificateRevocationList add(Credential val) {
        this.revoked.add(val);
        return this;
    }

    public byte[] getAsDer() throws CertificateException, NoSuchAlgorithmException, IOException {
        return this.generateCrl().getEncoded();
    }

    public String getAsPem() throws CertificateException, NoSuchAlgorithmException, IOException {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        pemWriter.writeObject((Object)this.generateCrl());
        pemWriter.flush();
        pemWriter.close();
        return writer.toString();
    }

    public CertificateRevocationList writeAsPem(Path out) throws IOException, CertificateException, NoSuchAlgorithmException {
        try (BufferedWriter writer = Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(this.getAsPem());
        }
        return this;
    }

    private X509CRLHolder generateCrl() throws CertificateException, NoSuchAlgorithmException {
        X509CRLHolder crlHolder;
        if (this.issuer == null) {
            if (this.revoked.isEmpty()) {
                throw new IllegalArgumentException("issuer not known: either set issuer or add certificates to the CRL");
            }
            this.issuer = this.revoked.get((int)0).issuer;
        }
        this.issuer.ensureGenerated();
        Date effectiveRevocationTime = new Date();
        if (this.thisUpdate != null) {
            effectiveRevocationTime = this.thisUpdate;
        }
        Duration week = Duration.ofDays(7L);
        Date effectiveExpiry = Date.from(effectiveRevocationTime.toInstant().plus(week));
        if (this.nextUpdate != null) {
            effectiveExpiry = this.nextUpdate;
        }
        X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(this.issuer.subject, effectiveRevocationTime);
        crlBuilder.setNextUpdate(effectiveExpiry);
        for (Credential credential : this.revoked) {
            credential.ensureGenerated();
            if (credential.issuer == null) {
                throw new IllegalArgumentException("cannot revoke self-signed certificate: " + String.valueOf(credential.subject));
            }
            if (!credential.issuer.equals(this.issuer)) {
                throw new IllegalArgumentException("revoked certificates added from several issuers, or certificate does not match explicitly set Issuer");
            }
            crlBuilder.addCRLEntry(credential.serial, effectiveRevocationTime, 0, effectiveExpiry);
        }
        try {
            ContentSigner signer = new JcaContentSignerBuilder(Credential.signatureAlgorithm(this.issuer.keyPair.getPublic())).build(this.issuer.keyPair.getPrivate());
            crlHolder = crlBuilder.build(signer);
        }
        catch (OperatorCreationException e) {
            throw new CertificateException("failed to create content signer", e);
        }
        return crlHolder;
    }
}

