/*
 * Decompiled with CFR 0.152.
 */
package fi.protonode.certy;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.EllipticCurve;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class Credential {
    protected X500Name subject;
    private GeneralNames subjectAltNames;
    private KeyType keyType;
    private int keySize;
    private Duration expires;
    private Date notBefore;
    private Date notAfter;
    private List<KeyUsage> keyUsages = new ArrayList<KeyUsage>();
    private List<ExtKeyUsage> extKeyUsages = new ArrayList<ExtKeyUsage>();
    protected Credential issuer;
    private Boolean isCa;
    protected BigInteger serial;
    private String crlDistributionPointUri;
    protected KeyPair keyPair;
    protected Certificate certificate;

    public Credential subject(String val) {
        this.subject = new X500Name(val);
        return this;
    }

    public Credential subjectAltNames(List<String> val) {
        this.subjectAltNames = Credential.asGeneralNames(val);
        return this;
    }

    public Credential subjectAltName(String val) {
        this.subjectAltNames = Credential.asGeneralNames(Arrays.asList(val));
        return this;
    }

    public Credential keyType(KeyType val) {
        this.keyType = val;
        return this;
    }

    public Credential keySize(int val) {
        this.keySize = val;
        return this;
    }

    public Credential expires(Duration val) {
        this.expires = val;
        return this;
    }

    public Credential notBefore(Date val) {
        this.notBefore = val;
        return this;
    }

    public Credential notAfter(Date val) {
        this.notAfter = val;
        return this;
    }

    public Credential keyUsages(List<KeyUsage> val) {
        this.keyUsages = val;
        return this;
    }

    public Credential extKeyUsages(List<ExtKeyUsage> val) {
        this.extKeyUsages = val;
        return this;
    }

    public Credential issuer(Credential val) {
        this.issuer = val;
        return this;
    }

    public Credential ca(Boolean val) {
        this.isCa = val;
        return this;
    }

    public Credential serial(BigInteger val) {
        this.serial = val;
        return this;
    }

    public Credential crlDistributionPointUri(String val) {
        this.crlDistributionPointUri = val;
        return this;
    }

    public Credential generate() throws CertificateException, NoSuchAlgorithmException {
        try {
            ContentSigner signer;
            X500Name effectiveIssuer;
            if (this.issuer != null) {
                this.issuer.ensureGenerated();
            }
            this.setDefaults();
            this.keyPair = Credential.newKeyPair(this.keyType, this.keySize);
            Date effectiveNotBefore = this.notBefore != null ? this.notBefore : new Date();
            Date effectiveNotAfter = this.notAfter != null ? this.notAfter : Date.from(effectiveNotBefore.toInstant().plus(this.expires));
            if (this.subject == null) {
                throw new IllegalArgumentException("subject name must be set");
            }
            if (this.issuer == null) {
                effectiveIssuer = this.subject;
                signer = new JcaContentSignerBuilder(Credential.signatureAlgorithm(this.keyPair.getPublic())).build(this.keyPair.getPrivate());
            } else {
                effectiveIssuer = this.issuer.subject;
                signer = new JcaContentSignerBuilder(Credential.signatureAlgorithm(this.issuer.keyPair.getPublic())).build(this.issuer.keyPair.getPrivate());
            }
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(effectiveIssuer, this.serial, effectiveNotBefore, effectiveNotAfter, this.subject, this.keyPair.getPublic());
            JcaX509ExtensionUtils utils = new JcaX509ExtensionUtils();
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(this.isCa.booleanValue())).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)utils.createSubjectKeyIdentifier(this.keyPair.getPublic())).addExtension(Extension.keyUsage, true, (ASN1Encodable)new org.bouncycastle.asn1.x509.KeyUsage(this.keyUsages.stream().collect(Collectors.summingInt(KeyUsage::getValue)).intValue()));
            if (this.subjectAltNames != null) {
                builder.addExtension(Extension.subjectAlternativeName, this.subject == null, (ASN1Encodable)this.subjectAltNames);
            }
            if (!this.extKeyUsages.isEmpty()) {
                builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage((KeyPurposeId[])this.extKeyUsages.stream().map(ExtKeyUsage::getValue).toArray(KeyPurposeId[]::new)));
            }
            if (this.crlDistributionPointUri != null) {
                DistributionPointName dp = new DistributionPointName(new GeneralNames(new GeneralName(6, this.crlDistributionPointUri)));
                builder.addExtension(Extension.cRLDistributionPoints, false, (ASN1Encodable)new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dp, null, null)}));
            }
            this.certificate = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(builder.build(signer));
        }
        catch (CertIOException | OperatorCreationException e) {
            throw new CertificateException(e.toString());
        }
        return this;
    }

    public String getCertificateAsPem() throws CertificateException, NoSuchAlgorithmException, IOException {
        this.ensureGenerated();
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        pemWriter.writeObject((Object)this.certificate);
        pemWriter.flush();
        pemWriter.close();
        return writer.toString();
    }

    public String getCertificatesAsPem() throws CertificateException, NoSuchAlgorithmException, IOException {
        this.ensureGenerated();
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        for (Certificate c : this.getChain()) {
            pemWriter.writeObject((Object)c);
        }
        pemWriter.flush();
        pemWriter.close();
        return writer.toString();
    }

    public String getPrivateKeyAsPem() throws IOException, CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        pemWriter.writeObject((PemObjectGenerator)new JcaPKCS8Generator(this.keyPair.getPrivate(), null));
        pemWriter.flush();
        pemWriter.close();
        return writer.toString();
    }

    public Credential writeCertificateAsPem(Path out) throws IOException, CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        try (BufferedWriter writer = Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]);){
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            pemWriter.writeObject((Object)this.certificate);
            pemWriter.flush();
            pemWriter.close();
        }
        return this;
    }

    public Credential writeCertificatesAsPem(Path out) throws IOException, CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        try (BufferedWriter writer = Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]);){
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            for (Certificate c : this.getChain()) {
                pemWriter.writeObject((Object)c);
            }
            pemWriter.flush();
            pemWriter.close();
        }
        return this;
    }

    public Credential writePrivateKeyAsPem(Path out) throws IOException, CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        try (BufferedWriter writer = Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]);){
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            pemWriter.writeObject((PemObjectGenerator)new JcaPKCS8Generator(this.keyPair.getPrivate(), null));
            pemWriter.flush();
            pemWriter.close();
        }
        return this;
    }

    public Certificate getCertificate() throws CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        return this.certificate;
    }

    public Certificate[] getCertificates() throws CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        return this.getChain();
    }

    public X509Certificate getX509Certificate() throws CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        return (X509Certificate)this.certificate;
    }

    public X509Certificate[] getX509Certificates() throws CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        return (X509Certificate[])Arrays.stream(this.getChain()).map(c -> (X509Certificate)c).toArray(X509Certificate[]::new);
    }

    public PrivateKey getPrivateKey() throws CertificateException, NoSuchAlgorithmException {
        this.ensureGenerated();
        return this.keyPair.getPrivate();
    }

    protected void ensureGenerated() throws CertificateException, NoSuchAlgorithmException {
        if (this.certificate == null || this.keyPair == null) {
            this.generate();
        }
    }

    private void setDefaults() {
        if (this.keyType == null) {
            this.keyType = KeyType.EC;
        }
        if (this.keySize == 0) {
            if (this.keyType == KeyType.EC) {
                this.keySize = 256;
            } else if (this.keyType == KeyType.RSA) {
                this.keySize = 2048;
            } else if (this.keyType == KeyType.ED25519) {
                this.keySize = 255;
            }
        }
        if (this.expires == null && this.notAfter == null) {
            this.expires = Duration.of(365L, ChronoUnit.DAYS);
        }
        if (this.isCa == null) {
            boolean noExplicitIssuer = this.issuer == null;
            this.isCa = noExplicitIssuer;
        }
        if (this.keyUsages.isEmpty()) {
            this.keyUsages = Boolean.TRUE.equals(this.isCa) ? Arrays.asList(KeyUsage.KEY_CERT_SIGN, KeyUsage.CRL_SIGN) : (this.keyType == KeyType.EC ? Arrays.asList(KeyUsage.KEY_ENCIPHERMENT, KeyUsage.DIGITAL_SIGNATURE, KeyUsage.KEY_AGREEMENT) : Arrays.asList(KeyUsage.KEY_ENCIPHERMENT, KeyUsage.DIGITAL_SIGNATURE));
        }
        if (this.serial == null) {
            this.serial = BigInteger.valueOf(Instant.now().toEpochMilli());
        }
    }

    private static KeyPair newKeyPair(KeyType keyType, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyType.name());
        SecureRandom prng = new SecureRandom();
        keyGen.initialize(keySize, prng);
        return keyGen.genKeyPair();
    }

    protected static String signatureAlgorithm(PublicKey pub) {
        switch (pub.getAlgorithm()) {
            case "EC": {
                EllipticCurve curve = ((ECPublicKey)pub).getParams().getCurve();
                switch (curve.getField().getFieldSize()) {
                    case 224: 
                    case 256: {
                        return "SHA256withECDSA";
                    }
                    case 384: {
                        return "SHA384withECDSA";
                    }
                    case 521: {
                        return "SHA512withECDSA";
                    }
                }
                throw new IllegalArgumentException("unknown elliptic curve: " + String.valueOf(curve));
            }
            case "RSA": {
                return "SHA256WithRSAEncryption";
            }
            case "EdDSA": {
                return "Ed25519";
            }
        }
        throw new UnsupportedOperationException("unsupported private key algorithm: " + pub.getAlgorithm());
    }

    private static GeneralNames asGeneralNames(List<String> sans) {
        ArrayList<GeneralName> altNames = new ArrayList<GeneralName>();
        for (String name : sans) {
            int separatorPos = name.indexOf(":");
            if (separatorPos == -1) {
                throw new IllegalArgumentException("cannot parse " + name + ": all subjectAltNames must be of format: DNS:www.example.com, IP:1.2.3.4, URI:https://www.example.com");
            }
            String type = name.substring(0, separatorPos);
            String value = name.substring(separatorPos + 1);
            switch (type) {
                case "DNS": {
                    altNames.add(new GeneralName(2, value));
                    break;
                }
                case "IP": {
                    altNames.add(new GeneralName(7, value));
                    break;
                }
                case "URI": {
                    altNames.add(new GeneralName(6, value));
                    break;
                }
            }
        }
        if (altNames.isEmpty()) {
            throw new IllegalArgumentException("subjectAltNames must be of format: DNS:www.example.com, IP:1.2.3.4, URI:https://www.example.com");
        }
        return GeneralNames.getInstance((Object)new DERSequence((ASN1Encodable[])altNames.toArray(new GeneralName[0])));
    }

    private Certificate[] getChain() {
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        chain.add(this.certificate);
        Credential parent = this.issuer;
        while (parent != null && parent.issuer != null) {
            chain.add(parent.certificate);
            parent = parent.issuer;
        }
        return chain.toArray(new Certificate[0]);
    }

    public static enum KeyType {
        EC,
        RSA,
        ED25519;

    }

    public static enum KeyUsage {
        DIGITAL_SIGNATURE(128),
        NON_REPUDIATION(64),
        KEY_ENCIPHERMENT(32),
        DATA_ENCIPHERMENT(16),
        KEY_AGREEMENT(8),
        KEY_CERT_SIGN(4),
        CRL_SIGN(2),
        ENCIPHER_ONLY(1),
        DECIPHER_ONLY(32768);

        private int val;

        private KeyUsage(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }

    public static enum ExtKeyUsage {
        ANY(KeyPurposeId.anyExtendedKeyUsage),
        SERVER_AUTH(KeyPurposeId.id_kp_serverAuth),
        CLIENT_AUTH(KeyPurposeId.id_kp_clientAuth),
        CODE_SIGNING(KeyPurposeId.id_kp_codeSigning),
        EMAIL_PROTECTION(KeyPurposeId.id_kp_emailProtection),
        TIME_STAMPING(KeyPurposeId.id_kp_timeStamping),
        OCSP_SIGNING(KeyPurposeId.id_kp_OCSPSigning);

        private KeyPurposeId val;

        private ExtKeyUsage(KeyPurposeId val) {
            this.val = val;
        }

        public KeyPurposeId getValue() {
            return this.val;
        }
    }
}

