/*
 * Decompiled with CFR 0.152.
 */
package fi.seco.hfst;

import java.io.IOException;

public class ByteArray {
    private final byte[] bytes;
    private int index;
    private final int size;

    public ByteArray(int s) {
        this.size = s;
        this.bytes = new byte[this.size];
        this.index = 0;
    }

    public ByteArray(ByteArray another, int s) {
        this.size = Math.max(s, another.getSize());
        this.bytes = new byte[this.size];
        int i = 0;
        while (i < another.getSize()) {
            this.bytes[i] = another.get(i);
            ++i;
        }
        this.index = 0;
    }

    public int getSize() {
        return this.size;
    }

    public byte get(int i) {
        return this.bytes[i];
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public short getUByte() {
        short result = 0;
        result = (short)(result | this.bytes[this.index]);
        ++this.index;
        return result;
    }

    public int getUShort() throws IOException {
        int result = 0;
        result |= this.bytes[this.index + 1] & 0xFF;
        result <<= 8;
        this.index += 2;
        return result |= this.bytes[this.index] & 0xFF;
    }

    public long getUInt() throws IOException {
        long result = 0L;
        result |= (long)(this.bytes[this.index + 3] & 0xFF);
        result <<= 8;
        result |= (long)(this.bytes[this.index + 2] & 0xFF);
        result <<= 8;
        result |= (long)(this.bytes[this.index + 1] & 0xFF);
        result <<= 8;
        this.index += 4;
        return result |= (long)(this.bytes[this.index] & 0xFF);
    }

    public boolean getBool() throws IOException {
        return this.getUInt() != 0L;
    }

    public float getFloat() throws IOException {
        int bits = 0;
        bits |= this.bytes[this.index + 3] & 0xFF;
        bits <<= 8;
        bits |= this.bytes[this.index + 2] & 0xFF;
        bits <<= 8;
        bits |= this.bytes[this.index + 1] & 0xFF;
        bits <<= 8;
        this.index += 4;
        return Float.intBitsToFloat(bits |= this.bytes[this.index] & 0xFF);
    }
}

