/*
 * Decompiled with CFR 0.152.
 */
package fi.seco.hfst;

import fi.seco.hfst.Transducer;
import fi.seco.hfst.TransducerAlphabet;
import fi.seco.hfst.TransducerHeader;
import fi.seco.hfst.UnweightedTransducer;
import fi.seco.hfst.WeightedTransducer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class HfstOptimizedLookup {
    public static final long TRANSITION_TARGET_TABLE_START = 0x80000000L;
    public static final long NO_TABLE_INDEX = 0xFFFFFFFFL;
    public static final float INFINITE_WEIGHT = 4.2949673E9f;
    public static final int NO_SYMBOL_NUMBER = 65535;

    public static void runTransducer(Transducer t) {
        System.out.println("Ready for input.");
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String str;
            try {
                str = stdin.readLine();
            }
            catch (IOException e) {
                break;
            }
            List<Transducer.Result> analyses = t.analyze(str);
            for (Transducer.Result analysis : analyses) {
                System.out.println(String.valueOf(str) + "\t" + analysis);
            }
            if (analyses.isEmpty()) {
                System.out.println(String.valueOf(str) + "\t+?");
            }
            System.out.println();
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length != 1) {
            System.err.println("Usage: java HfstRuntimeReader FILE");
            System.exit(1);
        }
        FileInputStream transducerfile = null;
        try {
            transducerfile = new FileInputStream(argv[0]);
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: couldn't read transducer file " + argv[0] + ".");
            System.exit(1);
        }
        System.out.println("Reading header...");
        DataInputStream charstream = new DataInputStream(transducerfile);
        TransducerHeader h = new TransducerHeader(charstream);
        System.out.println("Reading alphabet...");
        TransducerAlphabet a = new TransducerAlphabet(charstream, h.getSymbolCount());
        System.out.println("Reading transition and index tables...");
        if (h.isWeighted()) {
            WeightedTransducer transducer = new WeightedTransducer(charstream, h, a);
            HfstOptimizedLookup.runTransducer(transducer);
        } else {
            UnweightedTransducer transducer = new UnweightedTransducer(charstream, h, a);
            HfstOptimizedLookup.runTransducer(transducer);
        }
    }

    public static enum FlagDiacriticOperator {
        P,
        N,
        R,
        D,
        C,
        U;

    }
}

