/*
 * Decompiled with CFR 0.152.
 */
package fi.seco.hfst;

import com.carrotsearch.hppc.CharIntHashMap;
import com.carrotsearch.hppc.CharObjectHashMap;
import fi.seco.hfst.IndexString;

public class LetterTrie {
    private final LetterTrieNode root = new LetterTrieNode();

    public void addString(String str, int symbolNumber) {
        this.root.addString(str, symbolNumber);
    }

    int findKey(IndexString str) {
        return this.root.findKey(str);
    }

    public class LetterTrieNode {
        private final CharIntHashMap symbols = new CharIntHashMap();
        private final CharObjectHashMap<LetterTrieNode> children = new CharObjectHashMap();

        public void addString(String str, int symbolNumber) {
            if (str.length() > 1) {
                if (!this.children.containsKey(str.charAt(0))) {
                    this.children.put(str.charAt(0), (Object)new LetterTrieNode());
                }
                ((LetterTrieNode)this.children.get(str.charAt(0))).addString(str.substring(1, str.length()), symbolNumber);
            } else if (str.length() == 1) {
                this.symbols.put(str.charAt(0), symbolNumber);
            }
        }

        public int findKey(IndexString string) {
            if (string.index >= string.str.length()) {
                return 65535;
            }
            Character at_s = Character.valueOf(string.str.charAt(string.index));
            ++string.index;
            LetterTrieNode child = (LetterTrieNode)this.children.get(at_s.charValue());
            if (child == null) {
                int symbol = this.symbols.get(at_s.charValue());
                if (symbol == 0) {
                    --string.index;
                    return 65535;
                }
                return symbol;
            }
            int s = child.findKey(string);
            if (s == 65535) {
                int symbol = this.symbols.get(at_s.charValue());
                if (symbol == 0) {
                    --string.index;
                    return 65535;
                }
                return symbol;
            }
            return s;
        }
    }
}

