/*
 * Decompiled with CFR 0.152.
 */
package fi.seco.hfst;

import com.carrotsearch.hppc.ByteArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.ObjectIntHashMap;
import fi.seco.hfst.FlagDiacriticOperation;
import fi.seco.hfst.HfstOptimizedLookup;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class TransducerAlphabet {
    public ArrayList<String> keyTable = new ArrayList();
    public IntObjectMap<FlagDiacriticOperation> operations = new IntObjectHashMap();
    public int features;

    public TransducerAlphabet(DataInputStream charstream, int number_of_symbols) throws IOException {
        ObjectIntHashMap feature_bucket = new ObjectIntHashMap();
        ObjectIntHashMap value_bucket = new ObjectIntHashMap();
        this.features = 0;
        int values = 1;
        value_bucket.put((Object)"", 0);
        int i = 0;
        ByteArrayList chars = new ByteArrayList();
        while (i < number_of_symbols) {
            int charindex = 0;
            if (chars.size() == charindex) {
                chars.add(charstream.readByte());
            } else {
                chars.set(charindex, charstream.readByte());
            }
            while (chars.get(charindex) != 0) {
                if (chars.size() == ++charindex) {
                    chars.add(charstream.readByte());
                    continue;
                }
                chars.set(charindex, charstream.readByte());
            }
            String ustring = new String(chars.toArray(), 0, charindex, "UTF-8");
            if (ustring.length() > 5 && ustring.charAt(0) == '@' && ustring.charAt(ustring.length() - 1) == '@' && ustring.charAt(2) == '.') {
                HfstOptimizedLookup.FlagDiacriticOperator op;
                String[] parts = ustring.substring(1, ustring.length() - 1).split("\\.");
                if (parts.length < 2) {
                    this.keyTable.add("");
                    ++i;
                    continue;
                }
                String ops = parts[0];
                String feats = parts[1];
                String vals = parts.length == 3 ? parts[2] : "";
                if (ops.equals("P")) {
                    op = HfstOptimizedLookup.FlagDiacriticOperator.P;
                } else if (ops.equals("N")) {
                    op = HfstOptimizedLookup.FlagDiacriticOperator.N;
                } else if (ops.equals("R")) {
                    op = HfstOptimizedLookup.FlagDiacriticOperator.R;
                } else if (ops.equals("D")) {
                    op = HfstOptimizedLookup.FlagDiacriticOperator.D;
                } else if (ops.equals("C")) {
                    op = HfstOptimizedLookup.FlagDiacriticOperator.C;
                } else if (ops.equals("U")) {
                    op = HfstOptimizedLookup.FlagDiacriticOperator.U;
                } else {
                    this.keyTable.add("");
                    ++i;
                    continue;
                }
                if (!value_bucket.containsKey((Object)vals)) {
                    value_bucket.put((Object)vals, values);
                    ++values;
                }
                if (!feature_bucket.containsKey((Object)feats)) {
                    feature_bucket.put((Object)feats, this.features);
                    ++this.features;
                }
                this.operations.put(i, (Object)new FlagDiacriticOperation(op, feature_bucket.get((Object)feats), value_bucket.get((Object)vals)));
                this.keyTable.add("");
                ++i;
                continue;
            }
            this.keyTable.add(ustring);
            ++i;
        }
        this.keyTable.set(0, "");
    }
}

