/*
 * Decompiled with CFR 0.152.
 */
package fi.seco.hfst;

import fi.seco.hfst.ByteArray;
import java.io.DataInputStream;
import java.io.IOException;

public class TransducerHeader {
    private final int number_of_input_symbols;
    private final int number_of_symbols;
    private final int size_of_transition_index_table;
    private final int size_of_transition_target_table;
    private final int number_of_states;
    private final int number_of_transitions;
    private final boolean weighted;
    private final boolean deterministic;
    private final boolean input_deterministic;
    private final boolean minimized;
    private final boolean cyclic;
    private final boolean has_epsilon_epsilon_transitions;
    private final boolean has_input_epsilon_transitions;
    private final boolean has_input_epsilon_cycles;
    private final boolean has_unweighted_input_epsilon_cycles;
    private boolean hfst3 = false;
    private final boolean intact;

    public TransducerHeader(DataInputStream input) throws IOException {
        this.intact = true;
        ByteArray head = new ByteArray(5);
        input.readFully(head.getBytes());
        if (this.begins_hfst3_header(head)) {
            this.skip_hfst3_header(input);
            input.read(head.getBytes());
            this.hfst3 = true;
        }
        ByteArray b = new ByteArray(head, 56);
        input.readFully(b.getBytes(), 5, 51);
        this.number_of_input_symbols = b.getUShort();
        this.number_of_symbols = b.getUShort();
        this.size_of_transition_index_table = (int)b.getUInt();
        this.size_of_transition_target_table = (int)b.getUInt();
        this.number_of_states = (int)b.getUInt();
        this.number_of_transitions = (int)b.getUInt();
        this.weighted = b.getBool();
        this.deterministic = b.getBool();
        this.input_deterministic = b.getBool();
        this.minimized = b.getBool();
        this.cyclic = b.getBool();
        this.has_epsilon_epsilon_transitions = b.getBool();
        this.has_input_epsilon_transitions = b.getBool();
        this.has_input_epsilon_cycles = b.getBool();
        this.has_unweighted_input_epsilon_cycles = b.getBool();
    }

    public boolean begins_hfst3_header(ByteArray bytes) {
        if (bytes.getSize() < 5) {
            return false;
        }
        return bytes.getUByte() == 72 && bytes.getUByte() == 70 && bytes.getUByte() == 83 && bytes.getUByte() == 84 && bytes.getUByte() == 0;
    }

    public void skip_hfst3_header(DataInputStream file) throws IOException {
        ByteArray len = new ByteArray(2);
        file.readFully(len.getBytes());
        file.skip(len.getUShort() + 1);
    }

    public int getInputSymbolCount() {
        return this.number_of_input_symbols;
    }

    public int getSymbolCount() {
        return this.number_of_symbols;
    }

    public int getIndexTableSize() {
        return this.size_of_transition_index_table;
    }

    public int getTargetTableSize() {
        return this.size_of_transition_target_table;
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public boolean hasHfst3Header() {
        return this.hfst3;
    }

    public boolean isIntact() {
        return this.intact;
    }
}

