/*
 * Decompiled with CFR 0.152.
 */
package fi.seco.hfst;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectMap;
import fi.seco.hfst.ByteArray;
import fi.seco.hfst.FlagDiacriticOperation;
import fi.seco.hfst.HfstOptimizedLookup;
import fi.seco.hfst.IndexString;
import fi.seco.hfst.LetterTrie;
import fi.seco.hfst.Transducer;
import fi.seco.hfst.TransducerAlphabet;
import fi.seco.hfst.TransducerHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class WeightedTransducer
implements Transducer {
    protected TransducerHeader header;
    protected TransducerAlphabet alphabet;
    protected IntObjectMap<FlagDiacriticOperation> operations;
    protected LetterTrie letterTrie;
    protected IndexTable indexTable;
    protected TransitionTable transitionTable;

    public WeightedTransducer(DataInputStream file, TransducerHeader h, TransducerAlphabet a) throws IOException {
        this.header = h;
        this.alphabet = a;
        this.operations = this.alphabet.operations;
        this.letterTrie = new LetterTrie();
        int i = 0;
        while (i < this.header.getInputSymbolCount()) {
            this.letterTrie.addString(this.alphabet.keyTable.get(i), i);
            ++i;
        }
        this.indexTable = new IndexTable(file, this.header.getIndexTableSize());
        this.transitionTable = new TransitionTable(file, this.header.getTargetTableSize());
    }

    private int pivot(long i) {
        if (i >= 0x80000000L) {
            return (int)(i - 0x80000000L);
        }
        return (int)i;
    }

    private void tryEpsilonIndices(int index, State state) {
        if (this.indexTable.getInput(index) == 0) {
            this.tryEpsilonTransitions(this.pivot(this.indexTable.getTarget(index)), state);
        }
    }

    private void tryEpsilonTransitions(int index, State state) {
        while (true) {
            if (this.operations.containsKey(this.transitionTable.getInput(index))) {
                if (!this.pushState((FlagDiacriticOperation)this.operations.get(this.transitionTable.getInput(index)), state)) {
                    ++index;
                    continue;
                }
                if (state.outputPointer == state.outputString.size()) {
                    state.outputString.add(this.transitionTable.getOutput(index));
                } else {
                    state.outputString.set(state.outputPointer, this.transitionTable.getOutput(index));
                }
                ++state.outputPointer;
                state.current_weight += this.transitionTable.getWeight(index);
                this.getAnalyses(this.transitionTable.getTarget(index), state);
                state.current_weight -= this.transitionTable.getWeight(index);
                --state.outputPointer;
                ++index;
                state.stateStack.pop();
                continue;
            }
            if (this.transitionTable.getInput(index) != 0) break;
            if (state.outputPointer == state.outputString.size()) {
                state.outputString.add(this.transitionTable.getOutput(index));
            } else {
                state.outputString.set(state.outputPointer, this.transitionTable.getOutput(index));
            }
            ++state.outputPointer;
            state.current_weight += this.transitionTable.getWeight(index);
            this.getAnalyses(this.transitionTable.getTarget(index), state);
            state.current_weight -= this.transitionTable.getWeight(index);
            --state.outputPointer;
            ++index;
        }
    }

    private void findIndex(int index, State state) {
        if (this.indexTable.getInput(index + state.inputString.get(state.inputPointer - 1)) == state.inputString.get(state.inputPointer - 1)) {
            this.findTransitions(this.pivot(this.indexTable.getTarget(index + state.inputString.get(state.inputPointer - 1))), state);
        }
    }

    private void findTransitions(int index, State state) {
        while (this.transitionTable.getInput(index) != 65535) {
            if (this.transitionTable.getInput(index) == state.inputString.get(state.inputPointer - 1)) {
                if (state.outputPointer == state.outputString.size()) {
                    state.outputString.add(this.transitionTable.getOutput(index));
                } else {
                    state.outputString.set(state.outputPointer, this.transitionTable.getOutput(index));
                }
                ++state.outputPointer;
                state.current_weight += this.transitionTable.getWeight(index);
                this.getAnalyses(this.transitionTable.getTarget(index), state);
                state.current_weight -= this.transitionTable.getWeight(index);
                --state.outputPointer;
            } else {
                return;
            }
            ++index;
        }
    }

    private void getAnalyses(long idx, State state) {
        if (idx >= 0x80000000L) {
            int index = this.pivot(idx);
            this.tryEpsilonTransitions(index + 1, state);
            if (state.inputString.get(state.inputPointer) == 65535) {
                if (state.outputPointer == state.outputString.size()) {
                    state.outputString.add(65535);
                } else {
                    state.outputString.set(state.outputPointer, 65535);
                }
                if (this.transitionTable.size() > index && this.transitionTable.isFinal(index)) {
                    state.current_weight += this.transitionTable.getWeight(index);
                    this.noteAnalysis(state);
                    state.current_weight -= this.transitionTable.getWeight(index);
                }
                return;
            }
            ++state.inputPointer;
            this.findTransitions(index + 1, state);
        } else {
            int index = this.pivot(idx);
            this.tryEpsilonIndices(index + 1, state);
            if (state.inputString.get(state.inputPointer) == 65535) {
                if (state.outputPointer == state.outputString.size()) {
                    state.outputString.add(65535);
                } else {
                    state.outputString.set(state.outputPointer, 65535);
                }
                if (this.indexTable.isFinal(index)) {
                    state.current_weight += this.indexTable.getFinalWeight(index);
                    this.noteAnalysis(state);
                    state.current_weight -= this.indexTable.getFinalWeight(index);
                }
                return;
            }
            ++state.inputPointer;
            this.findIndex(index + 1, state);
        }
        --state.inputPointer;
        if (state.outputPointer == state.outputString.size()) {
            state.outputString.add(65535);
        } else {
            state.outputString.set(state.outputPointer, 65535);
        }
    }

    private List<String> getSymbols(State state) {
        int i = 0;
        ArrayList<String> symbols = new ArrayList<String>();
        while (i < state.outputString.size() && state.outputString.get(i) != 65535) {
            symbols.add(this.alphabet.keyTable.get(state.outputString.get(i++)));
        }
        return symbols;
    }

    private void noteAnalysis(State state) {
        state.displayVector.add(new Transducer.Result(this.getSymbols(state), state.current_weight));
    }

    @Override
    public List<Transducer.Result> analyze(String input) {
        State state = new State(input);
        if (state.inputString.get(0) == 65535) {
            return Collections.emptyList();
        }
        this.getAnalyses(0L, state);
        return state.displayVector;
    }

    @Override
    public List<String> getAlphabet() {
        return this.alphabet.keyTable;
    }

    private boolean pushState(FlagDiacriticOperation flag, State state) {
        int[] top = new int[this.alphabet.features];
        System.arraycopy(state.stateStack.peek(), 0, top, 0, this.alphabet.features);
        if (flag.op == HfstOptimizedLookup.FlagDiacriticOperator.P) {
            state.stateStack.push(top);
            state.stateStack.peek()[flag.feature] = flag.value;
            return true;
        }
        if (flag.op == HfstOptimizedLookup.FlagDiacriticOperator.N) {
            state.stateStack.push(top);
            state.stateStack.peek()[flag.feature] = -1 * flag.value;
            return true;
        }
        if (flag.op == HfstOptimizedLookup.FlagDiacriticOperator.R) {
            if (flag.value == 0) {
                if (state.stateStack.peek()[flag.feature] == 0) {
                    return false;
                }
                state.stateStack.push(top);
                return true;
            }
            if (state.stateStack.peek()[flag.feature] == flag.value) {
                state.stateStack.push(top);
                return true;
            }
            return false;
        }
        if (flag.op == HfstOptimizedLookup.FlagDiacriticOperator.D) {
            if (flag.value == 0) {
                if (state.stateStack.peek()[flag.feature] != 0) {
                    return false;
                }
                state.stateStack.push(top);
                return true;
            }
            if (state.stateStack.peek()[flag.feature] == flag.value) {
                return false;
            }
            state.stateStack.push(top);
            return true;
        }
        if (flag.op == HfstOptimizedLookup.FlagDiacriticOperator.C) {
            state.stateStack.push(top);
            state.stateStack.peek()[flag.feature] = 0;
            return true;
        }
        if (flag.op == HfstOptimizedLookup.FlagDiacriticOperator.U) {
            if (state.stateStack.peek()[flag.feature] == 0 || state.stateStack.peek()[flag.feature] == flag.value || state.stateStack.peek()[flag.feature] != flag.value && state.stateStack.peek()[flag.feature] < 0) {
                state.stateStack.push(top);
                state.stateStack.peek()[flag.feature] = flag.value;
                return true;
            }
            return false;
        }
        return false;
    }

    public static class IndexTable {
        private final int[] ti_inputSymbols;
        private final long[] ti_targets;

        public int getInput(int i) {
            return this.ti_inputSymbols[i];
        }

        public long getTarget(int i) {
            return this.ti_targets[i];
        }

        public boolean isFinal(int i) {
            return this.ti_inputSymbols[i] == 65535 && this.ti_targets[i] != 0xFFFFFFFFL;
        }

        public float getFinalWeight(int i) {
            return Float.intBitsToFloat((int)this.ti_targets[i]);
        }

        public IndexTable(DataInputStream input, int indicesCount) throws IOException {
            ByteArray b = new ByteArray(indicesCount * 6);
            input.readFully(b.getBytes());
            this.ti_inputSymbols = new int[indicesCount];
            this.ti_targets = new long[indicesCount];
            int i = 0;
            while (i < indicesCount) {
                this.ti_inputSymbols[i] = b.getUShort();
                this.ti_targets[i] = b.getUInt();
                ++i;
            }
        }
    }

    private class State {
        protected Stack<int[]> stateStack = new Stack();
        protected ArrayList<Transducer.Result> displayVector;
        protected IntArrayList outputString;
        protected IntArrayList inputString;
        protected int outputPointer;
        protected int inputPointer;
        protected float current_weight;

        public State(String input) {
            int[] neutral = new int[WeightedTransducer.this.alphabet.features];
            int i = 0;
            while (i < neutral.length) {
                neutral[i] = 0;
                ++i;
            }
            this.stateStack.push(neutral);
            this.outputString = new IntArrayList();
            this.inputString = new IntArrayList();
            this.outputPointer = 0;
            this.inputPointer = 0;
            this.current_weight = 0.0f;
            this.displayVector = new ArrayList();
            IndexString inputLine = new IndexString(input);
            while (inputLine.index < input.length()) {
                this.inputString.add(WeightedTransducer.this.letterTrie.findKey(inputLine));
                if (this.inputString.get(this.inputString.size() - 1) != 65535) continue;
                this.inputString.clear();
                break;
            }
            this.inputString.add(65535);
        }
    }

    public static class TransitionTable {
        private final int[] ti_inputSymbols;
        private final int[] ti_outputSymbols;
        private final long[] ti_targets;
        private final float[] ti_weights;

        public TransitionTable(DataInputStream input, int transitionCount) throws IOException {
            ByteArray b = new ByteArray(transitionCount * 12);
            input.readFully(b.getBytes());
            this.ti_inputSymbols = new int[transitionCount];
            this.ti_outputSymbols = new int[transitionCount];
            this.ti_targets = new long[transitionCount];
            this.ti_weights = new float[transitionCount];
            int i = 0;
            while (i < transitionCount) {
                this.ti_inputSymbols[i] = b.getUShort();
                this.ti_outputSymbols[i] = b.getUShort();
                this.ti_targets[i] = b.getUInt();
                this.ti_weights[i] = b.getFloat();
                ++i;
            }
        }

        public int getInput(int pos) {
            return this.ti_inputSymbols[pos];
        }

        public int getOutput(int pos) {
            return this.ti_outputSymbols[pos];
        }

        public long getTarget(int pos) {
            return this.ti_targets[pos];
        }

        public float getWeight(int pos) {
            return this.ti_weights[pos];
        }

        public boolean isFinal(int pos) {
            return this.ti_inputSymbols[pos] == 65535 && this.ti_outputSymbols[pos] == 65535 && this.ti_targets[pos] == 1L;
        }

        public int size() {
            return this.ti_targets.length;
        }
    }
}

