/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.JavaVersion;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class DumbMethods
extends BytecodeScanningDetector {
    private static final ObjectType CONDITION_TYPE = new ObjectType("java.util.concurrent.locks.Condition");
    private HashSet<String> alreadyReported = new HashSet();
    private BugReporter bugReporter;
    private boolean sawCurrentTimeMillis;
    private BugInstance gcInvocationBugReport;
    private int gcInvocationPC;
    private CodeException[] exceptionTable;
    private String primitiveObjCtorSeen;
    private boolean ctorSeen;
    private boolean prevOpcodeWasReadLine;
    private int prevOpcode;
    private boolean isPublicStaticVoidMain;
    private int randomNextIntState;
    private boolean checkForBitIorofSignedByte;
    private boolean jdk15ChecksEnabled;
    OpcodeStack stack = new OpcodeStack();
    BugInstance pendingRemOfRandomIntBug;
    private static final int OOM_CATCH_LEN = 20;

    public DumbMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.jdk15ChecksEnabled = JavaVersion.getRuntimeVersion().isSameOrNewerThan(JavaVersion.JAVA_1_5);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Method method) {
        String cName = this.getDottedClassName();
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.isPublicStaticVoidMain = method.isPublic() && method.isStatic() && this.getMethodName().equals("main") || cName.toLowerCase().indexOf("benchmark") >= 0;
        this.prevOpcodeWasReadLine = false;
        this.pendingRemOfRandomIntBug = null;
        Code code = method.getCode();
        if (code != null) {
            this.exceptionTable = code.getExceptionTable();
        }
        if (this.exceptionTable == null) {
            this.exceptionTable = new CodeException[0];
        }
        this.primitiveObjCtorSeen = null;
        this.ctorSeen = false;
        this.randomNextIntState = 0;
        this.checkForBitIorofSignedByte = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        if (!(this.pendingRemOfRandomIntBug == null || seen == 184 && this.getClassConstantOperand().equals("java/lang/Math") && this.getNameConstantOperand().equals("abs"))) {
            this.bugReporter.reportBug(this.pendingRemOfRandomIntBug);
        }
        this.pendingRemOfRandomIntBug = null;
        try {
            String sig;
            OpcodeStack.Item item0;
            if (seen == 112) {
                item0 = this.stack.getStackItem(0);
                Object constant0 = item0.getConstant();
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                int special = item1.getSpecialKind();
                if (special == 2) {
                    this.pendingRemOfRandomIntBug = new BugInstance((Detector)this, "RV_REM_OF_RANDOM_INT", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this);
                } else if (constant0 instanceof Integer && (Integer)constant0 == 1) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "INT_BAD_REM_BY_1", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            if (this.checkForBitIorofSignedByte && seen != 145) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "BIT_IOR_OF_SIGNED_BYTE", this.prevOpcode == 129 ? 1 : 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                this.checkForBitIorofSignedByte = false;
            } else if ((seen == 128 || seen == 129) && this.stack.getStackDepth() >= 2) {
                item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                int special0 = item0.getSpecialKind();
                int special1 = item1.getSpecialKind();
                this.checkForBitIorofSignedByte = special0 == 1 && special1 == 3 || special0 == 3 && special1 == 1;
            } else {
                this.checkForBitIorofSignedByte = false;
            }
            if (this.prevOpcodeWasReadLine && seen == 182 && this.getClassConstantOperand().equals("java/lang/String")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NP_IMMEDIATE_DEREFERENCE_OF_READLINE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            this.prevOpcodeWasReadLine = (seen == 182 || seen == 185) && this.getNameConstantOperand().equals("readLine") && this.getSigConstantOperand().equals("()Ljava/lang/String;");
            switch (this.randomNextIntState) {
                case 0: {
                    if ((seen != 182 || !this.getClassConstantOperand().equals("java/util/Random") || !this.getNameConstantOperand().equals("nextLong")) && (seen != 184 || !this.getClassConstantOperand().equals("java/lang/Math") || !this.getNameConstantOperand().equals("random"))) break;
                    this.randomNextIntState = 1;
                    break;
                }
                case 1: {
                    if (seen == 142) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "RV_01_TO_INT", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        this.randomNextIntState = 0;
                        break;
                    }
                    this.randomNextIntState = 2;
                    break;
                }
                case 2: {
                    if (seen == 135) {
                        this.randomNextIntState = 3;
                        break;
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                case 3: {
                    if (seen == 107) {
                        this.randomNextIntState = 4;
                        break;
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                case 4: {
                    if (seen == 142) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_NEXTINT_VIA_NEXTDOUBLE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.isPublicStaticVoidMain && seen == 182 && this.getClassConstantOperand().startsWith("javax/swing/") && (this.getNameConstantOperand().equals("show") && this.getSigConstantOperand().equals("()V") || this.getNameConstantOperand().equals("pack") && this.getSigConstantOperand().equals("()V") || this.getNameConstantOperand().equals("setVisible") && this.getSigConstantOperand().equals("(Z)V"))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SW_SWING_METHODS_INVOKED_IN_SWING_THREAD", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (seen == 182 && this.getNameConstantOperand().equals("next") && this.getSigConstantOperand().equals("()Ljava/lang/Object;") && this.getMethodName().equals("hasNext") && this.getMethodSig().equals("()Z") && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_CALLING_NEXT_FROM_HASNEXT", item.isInitialParameter() && item.getRegisterNumber() == 0 ? 2 : 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this));
            }
            if (seen == 183 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("(Ljava/lang/String;)V") && this.alreadyReported.add(this.getRefConstantOperand())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_STRING_CTOR", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (seen == 184 && this.getClassConstantOperand().equals("java/lang/System") && this.getNameConstantOperand().equals("runFinalizersOnExit") || seen == 182 && this.getClassConstantOperand().equals("java/lang/Runtime") && this.getNameConstantOperand().equals("runFinalizersOnExit")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_RUN_FINALIZERS_ON_EXIT", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (seen == 183 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("()V") && this.alreadyReported.add(this.getRefConstantOperand())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_STRING_VOID_CTOR", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (!this.isPublicStaticVoidMain && seen == 184 && this.getClassConstantOperand().equals("java/lang/System") && this.getNameConstantOperand().equals("exit") && !this.getMethodName().equals("processWindowEvent") && !this.getMethodName().startsWith("windowClos") && this.getMethodName().indexOf("exit") == -1 && this.getMethodName().indexOf("Exit") == -1 && this.getMethodName().indexOf("crash") == -1 && this.getMethodName().indexOf("Crash") == -1 && this.getMethodName().indexOf("die") == -1 && this.getMethodName().indexOf("Die") == -1 && this.getMethodName().indexOf("main") == -1) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_EXIT", this.getMethod().isStatic() ? 3 : 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if ((seen == 184 && this.getClassConstantOperand().equals("java/lang/System") || seen == 182 && this.getClassConstantOperand().equals("java/lang/Runtime")) && this.getNameConstantOperand().equals("gc") && this.getSigConstantOperand().equals("()V") && !this.getDottedClassName().startsWith("java.lang") && !this.getMethodName().startsWith("gc") && !this.getMethodName().endsWith("gc") && this.alreadyReported.add(this.getRefConstantOperand())) {
                if (this.isPublicStaticVoidMain) {
                    return;
                }
                this.gcInvocationBugReport = new BugInstance((Detector)this, "DM_GC", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this);
                this.gcInvocationPC = this.getPC();
            }
            if (seen == 183 && this.getClassConstantOperand().equals("java/lang/Boolean") && this.getNameConstantOperand().equals("<init>") && !this.getClassName().equals("java/lang/Boolean") && this.alreadyReported.add(this.getRefConstantOperand())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_BOOLEAN_CTOR", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (seen == 184 && this.getClassConstantOperand().equals("java/lang/System") && (this.getNameConstantOperand().equals("currentTimeMillis") || this.getNameConstantOperand().equals("nanoTime"))) {
                this.sawCurrentTimeMillis = true;
            }
            if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("toString") && this.getSigConstantOperand().equals("()Ljava/lang/String;") && this.alreadyReported.add(this.getRefConstantOperand())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_STRING_TOSTRING", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && (this.getNameConstantOperand().equals("toUpperCase") || this.getNameConstantOperand().equals("toLowerCase")) && this.getSigConstantOperand().equals("()Ljava/lang/String;") && this.alreadyReported.add(this.getRefConstantOperand())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_CONVERT_CASE", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (seen == 183 && this.getNameConstantOperand().equals("<init>")) {
                String cls = this.getClassConstantOperand();
                String sig2 = this.getSigConstantOperand();
                this.primitiveObjCtorSeen = cls.equals("java/lang/Integer") && sig2.equals("(I)V") || cls.equals("java/lang/Float") && sig2.equals("(F)V") || cls.equals("java/lang/Double") && sig2.equals("(D)V") || cls.equals("java/lang/Long") && sig2.equals("(J)V") || cls.equals("java/lang/Byte") && sig2.equals("(B)V") || cls.equals("java/lang/Character") && sig2.equals("(C)V") || cls.equals("java/lang/Short") && sig2.equals("(S)V") || cls.equals("java/lang/Boolean") && sig2.equals("(Z)V") ? cls : null;
            } else if (this.primitiveObjCtorSeen != null && seen == 182 && this.getNameConstantOperand().equals("toString") && this.getClassConstantOperand().equals(this.primitiveObjCtorSeen) && this.getSigConstantOperand().equals("()Ljava/lang/String;")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_BOXED_PRIMITIVE_TOSTRING", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                this.primitiveObjCtorSeen = null;
            } else {
                this.primitiveObjCtorSeen = null;
            }
            if (seen == 183 && this.getNameConstantOperand().equals("<init>")) {
                this.ctorSeen = true;
            } else if (this.ctorSeen && seen == 182 && this.getClassConstantOperand().equals("java/lang/Object") && this.getNameConstantOperand().equals("getClass") && this.getSigConstantOperand().equals("()Ljava/lang/Class;")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_NEW_FOR_GETCLASS", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                this.ctorSeen = false;
            } else {
                this.ctorSeen = false;
            }
            if (this.jdk15ChecksEnabled && seen == 182 && this.isMonitorWait(this.getNameConstantOperand(), this.getSigConstantOperand())) {
                this.checkMonitorWait();
            }
            if (seen == 183 && this.getNameConstantOperand().equals("<init>") && this.getClassConstantOperand().equals("java/lang/Thread") && ((sig = this.getSigConstantOperand()).equals("()V") || sig.equals("(Ljava/lang/String;)V") || sig.equals("(Ljava/lang/ThreadGroup;Ljava/lang/String;)V")) && (!this.getMethodName().equals("<init>") || this.getPC() > 20)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DM_USELESS_THREAD", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            this.prevOpcode = seen;
        }
    }

    private void checkMonitorWait() {
        try {
            TypeDataflow typeDataflow = this.getClassContext().getTypeDataflow(this.getMethod());
            TypeDataflow.LocationAndFactPair pair = typeDataflow.getLocationAndFactForInstruction(this.getPC());
            if (pair == null) {
                return;
            }
            Type receiver = (Type)pair.frame.getInstance(pair.location.getHandle().getInstruction(), this.getClassContext().getConstantPoolGen());
            if (!(receiver instanceof ReferenceType)) {
                return;
            }
            if (Hierarchy.isSubtype((ReferenceType)((ReferenceType)receiver), (ReferenceType)CONDITION_TYPE)) {
                this.bugReporter.reportBug(new BugInstance("DM_MONITOR_WAIT_ON_CONDITION", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("Exception caught by DumbMethods", (Throwable)e);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Exception caught by DumbMethods", (Throwable)e);
        }
    }

    private boolean isMonitorWait(String name, String sig) {
        return name.equals("wait") && (sig.equals("()V") || sig.equals("(J)V") || sig.equals("(JI)V"));
    }

    public void visit(Code obj) {
        super.visit(obj);
        this.flush();
    }

    public void report() {
    }

    private void flush() {
        if (this.gcInvocationBugReport != null && !this.sawCurrentTimeMillis) {
            boolean outOfMemoryHandler = false;
            CodeException[] arr$ = this.exceptionTable;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String exClassName;
                ConstantPool cp;
                Constant constant;
                int catchTypeIndex;
                CodeException handler = arr$[i$];
                if (this.gcInvocationPC < handler.getHandlerPC() || this.gcInvocationPC > handler.getHandlerPC() + 20 || (catchTypeIndex = handler.getCatchType()) <= 0 || !((constant = (cp = this.getThisClass().getConstantPool()).getConstant(catchTypeIndex)) instanceof ConstantClass) || !(exClassName = (String)((ConstantClass)constant).getConstantValue(cp)).equals("java/lang/OutOfMemoryError")) continue;
                outOfMemoryHandler = true;
                break;
            }
            if (!outOfMemoryHandler) {
                this.bugReporter.reportBug(this.gcInvocationBugReport);
            }
        }
        this.sawCurrentTimeMillis = false;
        this.gcInvocationBugReport = null;
        this.alreadyReported.clear();
        this.exceptionTable = null;
    }
}

