/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.detect.Analyze;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindNonSerializableStoreIntoSession
implements Detector {
    private BugReporter bugReporter;
    private static final boolean DEBUG = false;

    public FindNonSerializableStoreIntoSession(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        Method[] arr$ = methodList = classContext.getJavaClass().getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return;
        }
        if (bytecodeSet.get(193) || bytecodeSet.get(192)) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            ReferenceType refType;
            Type operandType;
            TypeFrame frame;
            String cName;
            INVOKEINTERFACE invoke;
            String mName;
            Location location = (Location)i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof INVOKEINTERFACE) || !(mName = (invoke = (INVOKEINTERFACE)ins).getMethodName(cpg)).equals("setAttribute") || !(cName = invoke.getClassName(cpg)).equals("javax.servlet.http.HttpSession") || !(frame = typeDataflow.getFactAtLocation(location)).isValid() || (operandType = (Type)frame.getTopValue()).equals(TopType.instance()) || !(operandType instanceof ReferenceType) || (refType = (ReferenceType)operandType).equals(NullType.instance())) continue;
            String refSig = refType.getSignature();
            try {
                double isSerializable = Analyze.isDeepSerializable(refSig);
                if (!(isSerializable < 0.9)) continue;
                SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
                this.bugReporter.reportBug(new BugInstance((Detector)this, "J2EE_STORE_OF_NON_SERIALIZABLE_OBJECT_INTO_SESSION", isSerializable < 0.15 ? 1 : (isSerializable > 0.5 ? 3 : 2)).addClassAndMethod(methodGen, sourceFile).addSourceLine(sourceLineAnnotation).addClass(Analyze.getComponentClass(refSig)));
            }
            catch (ClassNotFoundException e) {}
        }
    }

    public void report() {
    }
}

