/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindUninitializedGet
extends BytecodeScanningDetector
implements StatelessDetector {
    Set<FieldAnnotation> initializedFields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> declaredFields = new HashSet<FieldAnnotation>();
    boolean inConstructor;
    boolean thisOnTOS = false;
    private BugReporter bugReporter;
    private static final int UNKNOWN_PRIORITY = -1;

    public FindUninitializedGet(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
        this.declaredFields.clear();
        super.visit(obj);
    }

    public void visit(Field obj) {
        super.visit(obj);
        FieldAnnotation f = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
        this.declaredFields.add(f);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.initializedFields.clear();
        this.thisOnTOS = false;
        this.inConstructor = this.getMethodName().equals("<init>") && this.getMethodSig().indexOf(this.getClassName()) == -1;
    }

    public void sawOpcode(int seen) {
        if (!this.inConstructor) {
            return;
        }
        if (seen == 42) {
            this.thisOnTOS = true;
            return;
        }
        if (seen == 181 && this.getClassConstantOperand().equals(this.getClassName())) {
            this.initializedFields.add(FieldAnnotation.fromReferencedField((DismantleBytecode)this));
        } else if (this.thisOnTOS && seen == 180 && this.getClassConstantOperand().equals(this.getClassName())) {
            FieldAnnotation f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
            byte nextOpcode = this.codeBytes[this.getPC() + 3];
            if (nextOpcode != 87 && !this.initializedFields.contains(f) && this.declaredFields.contains(f)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "UR_UNINIT_READ", 2).addClassAndMethod((PreorderVisitor)this).addField(f).addSourceLine((BytecodeScanningDetector)this));
                this.initializedFields.add(FieldAnnotation.fromReferencedField((DismantleBytecode)this));
            }
        } else if (seen == 183 && (!this.getNameConstantOperand().equals("<init>") || this.getClassConstantOperand().equals(this.getClassName())) || seen == 184 && this.getNameConstantOperand().equals("doPrivileged") && this.getClassConstantOperand().equals("java/security/AccessController") || seen == 182 && this.getClassConstantOperand().equals(this.getClassName()) || seen == 182 && this.getNameConstantOperand().equals("start")) {
            this.inConstructor = false;
        }
        this.thisOnTOS = false;
    }
}

