/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindBadCast
extends BytecodeScanningDetector
implements StatelessDetector {
    private HashSet<String> castTo = new HashSet();
    BugReporter bugReporter;
    static final boolean DEBUG = false;
    private Set<String> concreteCollectionClasses = new HashSet<String>();
    private Set<String> abstractCollectionClasses = new HashSet<String>();
    private int parameters;
    OpcodeStack stack = new OpcodeStack();

    public FindBadCast(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.abstractCollectionClasses.add("java/util/Collection");
        this.abstractCollectionClasses.add("java/util/List");
        this.abstractCollectionClasses.add("java/util/Set");
        this.abstractCollectionClasses.add("java/util/Map");
        this.concreteCollectionClasses.add("java/util/LinkedHashMap");
        this.concreteCollectionClasses.add("java/util/LinkedHashSet");
        this.concreteCollectionClasses.add("java/util/HashMap");
        this.concreteCollectionClasses.add("java/util/HashSet");
        this.concreteCollectionClasses.add("java/util/TreeMap");
        this.concreteCollectionClasses.add("java/util/TreeSet");
        this.concreteCollectionClasses.add("java/util/ArrayList");
        this.concreteCollectionClasses.add("java/util/LinkedList");
        this.concreteCollectionClasses.add("java/util/Hashtable");
        this.concreteCollectionClasses.add("java/util/Vector");
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
    }

    public void visit(Code obj) {
        this.parameters = this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.castTo.clear();
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        if (this.stack.getStackDepth() > 0) {
            if (seen == 192 || seen == 193) {
                OpcodeStack.Item it = this.stack.getStackItem(0);
                String signature = it.getSignature();
                if (signature.length() > 0 && signature.charAt(0) == 'L') {
                    signature = signature.substring(1, signature.length() - 1);
                }
                String signatureDot = signature.replace('/', '.');
                String to = this.getClassConstantOperand();
                if (to.length() > 0 && to.charAt(0) == 'L') {
                    to = to.substring(1, to.length() - 1);
                }
                String toDot = to.replace('/', '.');
                if (signature.length() > 0 && !signature.equals("java/lang/Object") && !signature.equals(to)) {
                    try {
                        JavaClass toClass = Repository.lookupClass((String)toDot);
                        JavaClass signatureClass = Repository.lookupClass((String)signatureDot);
                        if (!this.castTo.contains(to) && !Repository.instanceOf((JavaClass)signatureClass, (JavaClass)toClass)) {
                            if (!Repository.instanceOf((JavaClass)toClass, (JavaClass)signatureClass) && (!toClass.isInterface() && !signatureClass.isInterface() || signatureClass.isFinal() || toClass.isFinal())) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, seen == 192 ? "BC_IMPOSSIBLE_CAST" : "BC_IMPOSSIBLE_INSTANCEOF", seen == 192 ? 1 : 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addClass(signatureDot).addClass(toDot));
                            } else if (seen == 192) {
                                int reg;
                                int priority = 2;
                                if (Repository.instanceOf((JavaClass)toClass, (JavaClass)signatureClass)) {
                                    priority += 2;
                                }
                                if (this.getThisClass().equals((Object)toClass) || this.getThisClass().equals((Object)signatureClass)) {
                                    ++priority;
                                }
                                if (toClass.isInterface()) {
                                    ++priority;
                                }
                                if (priority <= 3 && (signatureClass.isInterface() || signatureClass.isAbstract())) {
                                    ++priority;
                                }
                                if (this.concreteCollectionClasses.contains(signature) || this.abstractCollectionClasses.contains(signature)) {
                                    --priority;
                                }
                                if (this.concreteCollectionClasses.contains(to) || this.abstractCollectionClasses.contains(to)) {
                                    --priority;
                                }
                                if ((reg = it.getRegisterNumber()) >= 0 && reg < this.parameters && it.isInitialParameter() && this.getMethod().isPublic() && this.getPC() < 4 && --priority > 3) {
                                    --priority;
                                }
                                if (this.getMethodName().equals("compareTo")) {
                                    ++priority;
                                }
                                if (priority < 1) {
                                    priority = 1;
                                }
                                if (priority <= 3) {
                                    String bug = "BC_UNCONFIRMED_CAST";
                                    if (this.concreteCollectionClasses.contains(to)) {
                                        bug = "BC_BAD_CAST_TO_CONCRETE_COLLECTION";
                                    } else if (this.abstractCollectionClasses.contains(to) && (signature.equals("java/util/Collection") || signature.equals("java/lang/Iterable"))) {
                                        bug = "BC_BAD_CAST_TO_ABSTRACT_COLLECTION";
                                    }
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, bug, priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addClass(signatureDot).addClass(toDot));
                                }
                            }
                        }
                    }
                    catch (RuntimeException e) {
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            if (seen == 193) {
                String to = this.getClassConstantOperand();
                this.castTo.add(to);
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

