/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class RedundantInterfaces
extends PreorderVisitor
implements Detector,
StatelessDetector {
    private BugReporter bugReporter;

    public RedundantInterfaces(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass obj = classContext.getJavaClass();
        String superClassName = obj.getSuperclassName();
        if (superClassName.equals("java.lang.Object")) {
            return;
        }
        String[] interfaceNames = obj.getInterfaceNames();
        if (interfaceNames == null || interfaceNames.length == 0) {
            return;
        }
        try {
            JavaClass superObj = obj.getSuperClass();
            TreeSet<String> redundantInfNames = new TreeSet<String>();
            String[] arr$ = interfaceNames;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String interfaceName = arr$[i$];
                JavaClass inf = Repository.lookupClass((String)interfaceName.replace('/', '.'));
                if (!superObj.instanceOf(inf)) continue;
                redundantInfNames.add(inf.getClassName());
            }
            if (redundantInfNames.size() > 0) {
                BugInstance bug = new BugInstance((Detector)this, "RI_REDUNDANT_INTERFACES", 3).addClass(obj);
                Iterator i$ = redundantInfNames.iterator();
                while (i$.hasNext()) {
                    String redundantInfName = (String)i$.next();
                    bug.addClass(redundantInfName).describe("INTERFACE_TYPE");
                }
                this.bugReporter.reportBug(bug);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void report() {
    }
}

