/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.type.FieldStoreType;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class TrainFieldStoreTypes
implements TrainingDetector {
    private BugReporter bugReporter;
    private FieldStoreTypeDatabase database;

    public TrainFieldStoreTypes(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.database = new FieldStoreTypeDatabase();
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        Method[] arr$ = methodList = classContext.getJavaClass().getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error compting field store types", (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error compting field store types", (Throwable)e);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException, ClassNotFoundException {
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Type storeType;
            TypeFrame frame;
            XField xfield;
            FieldInstruction fins;
            Type fieldType;
            Location location = (Location)i.next();
            Instruction ins = location.getHandle().getInstruction();
            short opcode = ins.getOpcode();
            if (opcode != 181 && opcode != 179 || !((fieldType = (fins = (FieldInstruction)ins).getType(cpg)) instanceof ReferenceType) || (xfield = Hierarchy.findXField((FieldInstruction)fins, (ConstantPoolGen)cpg)) == null || xfield.isPublic() || xfield.isProtected() || !(frame = typeDataflow.getFactAtLocation(location)).isValid() || !((storeType = (Type)frame.getTopValue()) instanceof ReferenceType)) continue;
            FieldStoreType property = (FieldStoreType)this.database.getProperty((Object)xfield);
            if (property == null) {
                property = new FieldStoreType();
                this.database.setProperty((Object)xfield, (Object)property);
            }
            property.addTypeSignature(storeType.getSignature());
        }
    }

    public void report() {
        AnalysisContext.currentAnalysisContext().storePropertyDatabase((PropertyDatabase)this.database, "fieldStoreTypes.db", "store type database");
    }
}

