/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class UselessSubclassMethod
extends BytecodeScanningDetector
implements StatelessDetector {
    public static final int SEEN_NOTHING = 0;
    public static final int SEEN_PARM = 1;
    public static final int SEEN_LAST_PARM = 2;
    public static final int SEEN_INVOKE = 3;
    public static final int SEEN_RETURN = 4;
    public static final int SEEN_INVALID = 5;
    private BugReporter bugReporter;
    private String superclassName;
    private int state;
    private int curParm;
    private int curParmOffset;
    private int invokePC;
    private Type[] argTypes;
    private Set<String> interfaceMethods = null;
    static /* synthetic */ Class class$org$apache$bcel$classfile$Synthetic;

    public UselessSubclassMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            this.superclassName = cls.getSuperclassName();
            JavaClass[] interfaces = null;
            if (cls.isClass() && (cls.getAccessFlags() & 0x400) != 0) {
                interfaces = cls.getAllInterfaces();
                this.interfaceMethods = new HashSet<String>();
                JavaClass[] arr$ = interfaces;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Method[] infMethods;
                    JavaClass aInterface = arr$[i$];
                    Method[] arr$2 = infMethods = aInterface.getMethods();
                    int len$2 = arr$2.length;
                    for (int i$2 = 0; i$2 < len$2; ++i$2) {
                        Method meth = arr$2[i$2];
                        this.interfaceMethods.add(meth.getName() + meth.getSignature());
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        super.visitClassContext(classContext);
    }

    public void visitAfter(JavaClass obj) {
        this.interfaceMethods = null;
        super.visitAfter(obj);
    }

    public void visitMethod(Method obj) {
        if (this.interfaceMethods != null && (obj.getAccessFlags() & 0x400) != 0) {
            String curDetail = obj.getName() + obj.getSignature();
            Iterator<String> i$ = this.interfaceMethods.iterator();
            while (i$.hasNext()) {
                String infMethodDetail = i$.next();
                if (!curDetail.equals(infMethodDetail)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "USM_USELESS_ABSTRACT_METHOD", 3).addClassAndMethod(this.getClassContext().getJavaClass(), obj));
            }
        }
        super.visitMethod(obj);
    }

    public void visitCode(Code obj) {
        try {
            String methodName = this.getMethodName();
            if (!methodName.equals("<init>") && !methodName.equals("clone") && (this.getMethod().getAccessFlags() & 0x1008) == 0) {
                Attribute[] atts;
                Attribute[] arr$ = atts = this.getMethod().getAttributes();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Attribute att = arr$[i$];
                    if (!att.getClass().equals(class$org$apache$bcel$classfile$Synthetic == null ? UselessSubclassMethod.class$("org.apache.bcel.classfile.Synthetic") : class$org$apache$bcel$classfile$Synthetic)) continue;
                    return;
                }
                byte[] codeBytes = obj.getCode();
                if (codeBytes.length == 0 || codeBytes[0] != 42) {
                    return;
                }
                this.state = 0;
                this.invokePC = 0;
                super.visitCode(obj);
                if (this.state == 4 && this.invokePC != 0) {
                    Method superMethod = this.findSuperclassMethod(this.superclassName, this.getMethod());
                    if (superMethod == null || this.accessModifiersAreDifferent(this.getMethod(), superMethod)) {
                        return;
                    }
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "USM_USELESS_SUBCLASS_METHOD", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.invokePC));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen == 42) {
                    this.argTypes = Type.getArgumentTypes((String)this.getMethodSig());
                    this.curParm = 0;
                    this.curParmOffset = 1;
                    if (this.argTypes.length > 0) {
                        this.state = 1;
                        break;
                    }
                    this.state = 2;
                    break;
                }
                this.state = 5;
                break;
            }
            case 1: {
                String signature;
                char typeChar0;
                if (this.curParm >= this.argTypes.length) {
                    this.state = 5;
                    break;
                }
                if ((typeChar0 = (signature = this.argTypes[this.curParm++].getSignature()).charAt(0)) == 'L' || typeChar0 == '[') {
                    this.checkParm(seen, 42, 25, 1);
                } else if (typeChar0 == 'D') {
                    this.checkParm(seen, 38, 24, 2);
                } else if (typeChar0 == 'F') {
                    this.checkParm(seen, 34, 23, 1);
                } else if (typeChar0 == 'I') {
                    this.checkParm(seen, 26, 21, 1);
                } else if (typeChar0 == 'J') {
                    this.checkParm(seen, 30, 22, 2);
                }
                if (this.state == 5 || this.curParm < this.argTypes.length) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (seen == 183 && this.getMethodName().equals(this.getNameConstantOperand()) && this.getMethodSig().equals(this.getSigConstantOperand())) {
                    this.invokePC = this.getPC();
                    this.state = 3;
                    break;
                }
                this.state = 5;
                break;
            }
            case 3: {
                Type returnType = this.getMethod().getReturnType();
                char retSigChar0 = returnType.getSignature().charAt(0);
                if (retSigChar0 == 'V' && seen == 177) {
                    this.state = 4;
                    break;
                }
                if ((retSigChar0 == 'L' || retSigChar0 == '[') && seen == 176) {
                    this.state = 4;
                    break;
                }
                if (retSigChar0 == 'D' && seen == 175) {
                    this.state = 4;
                    break;
                }
                if (retSigChar0 == 'F' && seen == 174) {
                    this.state = 4;
                    break;
                }
                if (retSigChar0 == 'I' && seen == 172) {
                    this.state = 4;
                    break;
                }
                if (retSigChar0 == 'J' && seen == 173) {
                    this.state = 4;
                    break;
                }
                this.state = 5;
                break;
            }
            case 4: {
                this.state = 5;
            }
        }
    }

    private void checkParm(int seen, int fastOpBase, int slowOp, int parmSize) {
        if (this.curParmOffset >= 1 && this.curParmOffset <= 3) {
            if (seen == fastOpBase + this.curParmOffset) {
                this.curParmOffset += parmSize;
            } else {
                this.state = 5;
            }
        } else if (this.curParmOffset == 0) {
            this.state = 5;
        } else if (seen == slowOp && this.getRegisterOperand() == this.curParmOffset) {
            this.curParmOffset += parmSize;
        } else {
            this.state = 5;
        }
    }

    private Method findSuperclassMethod(String superclassName, Method subclassMethod) throws ClassNotFoundException {
        Method[] methods;
        String methodName = subclassMethod.getName();
        Type[] subArgs = null;
        JavaClass superClass = Repository.lookupClass((String)superclassName);
        Method[] arr$ = methods = superClass.getMethods();
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            Type[] superArgs;
            Method m = arr$[i$];
            if (!m.getName().equals(methodName)) continue;
            if (subArgs == null) {
                subArgs = Type.getArgumentTypes((String)subclassMethod.getSignature());
            }
            if (subArgs.length != (superArgs = Type.getArgumentTypes((String)m.getSignature())).length) continue;
            for (int j = 0; j < subArgs.length; ++j) {
                if (!superArgs[j].equals((Object)subArgs[j])) continue block0;
            }
            return m;
        }
        if (!superclassName.equals("Object")) {
            String superSuperClassName = superClass.getSuperclassName();
            if (superSuperClassName.equals(superclassName)) {
                throw new ClassNotFoundException("superclass of " + superclassName + " is itself");
            }
            return this.findSuperclassMethod(superClass.getSuperclassName(), subclassMethod);
        }
        return null;
    }

    private boolean accessModifiersAreDifferent(Method m1, Method m2) {
        int access2;
        int access1 = m1.getAccessFlags() & 7;
        return access1 != (access2 = m2.getAccessFlags() & 7);
    }
}

