/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import fish.payara.advisor.AdvisorBean;
import fish.payara.advisor.AdvisorInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class AdvisorAnnotationWithProperty
implements AdvisorInterface {
    @Override
    public VoidVisitor<List<AdvisorBean>> createVoidVisitor(String keyPattern, String valuePattern, String ... params) {
        return null;
    }

    @Override
    public VoidVisitor<List<AdvisorBean>> createVoidVisitor(String keyPattern, String valuePattern, String secondPattern) {
        return new AnnotationWithPropertyCollector(keyPattern, valuePattern, secondPattern);
    }

    public AdvisorBean parseFile(String keyPattern, String valuePattern, String secondPattern, File f) throws FileNotFoundException {
        ArrayList advisorBeanList = new ArrayList();
        VoidVisitor<List<AdvisorBean>> collector = this.createVoidVisitor(keyPattern, valuePattern, secondPattern);
        collector.visit(StaticJavaParser.parse((File)f), advisorBeanList);
        if (advisorBeanList.size() > 0) {
            AdvisorBean b = (AdvisorBean)advisorBeanList.get(0);
            b.setFile(f);
            return b;
        }
        return null;
    }

    private static class AnnotationWithPropertyCollector
    extends VoidVisitorAdapter<List<AdvisorBean>> {
        private final String keyPattern;
        private final String valuePattern;
        private final String secondPattern;

        public AnnotationWithPropertyCollector(String keyPattern, String valuePattern, String secondPattern) {
            this.keyPattern = keyPattern;
            this.valuePattern = valuePattern;
            this.secondPattern = secondPattern;
        }

        public void visit(NormalAnnotationExpr annotationDeclaration, List<AdvisorBean> collector) {
            super.visit(annotationDeclaration, collector);
            Optional p = annotationDeclaration.getBegin();
            String annotationName = this.valuePattern.substring(this.valuePattern.lastIndexOf(".") + 1, this.valuePattern.length());
            if (annotationDeclaration.toString().contains(annotationName) && annotationDeclaration.toString().contains(this.secondPattern)) {
                AdvisorBean advisorBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, annotationName + "@" + this.secondPattern).setLine(p.map(position -> "" + position.line).orElse("")).setAnnotationDeclaration(annotationDeclaration.toString()).build();
                collector.add(advisorBean);
            }
        }

        public void visit(SingleMemberAnnotationExpr singleMemberAnnotationExpr, List<AdvisorBean> collector) {
            super.visit(singleMemberAnnotationExpr, collector);
            Optional p = singleMemberAnnotationExpr.getBegin();
            String annotationName = this.valuePattern.substring(this.valuePattern.lastIndexOf(".") + 1, this.valuePattern.length());
            if (singleMemberAnnotationExpr.toString().contains(annotationName) && singleMemberAnnotationExpr.toString().contains(this.secondPattern)) {
                AdvisorBean advisorBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, annotationName + "@" + this.secondPattern).setLine(p.map(position -> "" + position.line).orElse("")).setAnnotationDeclaration(singleMemberAnnotationExpr.toString()).build();
                collector.add(advisorBean);
            }
        }

        public void visit(MarkerAnnotationExpr markerAnnotationExpr, List<AdvisorBean> collector) {
            super.visit(markerAnnotationExpr, collector);
            Optional p = markerAnnotationExpr.getBegin();
            String annotationName = this.valuePattern.substring(this.valuePattern.lastIndexOf(".") + 1, this.valuePattern.length());
            if (markerAnnotationExpr.toString().contains(annotationName) && markerAnnotationExpr.toString().contains(this.secondPattern)) {
                AdvisorBean advisorBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, annotationName + "@" + this.secondPattern).setLine(p.map(position -> "" + position.line).orElse("")).setAnnotationDeclaration(markerAnnotationExpr.toString()).build();
                collector.add(advisorBean);
            }
        }
    }
}

