/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import fish.payara.advisor.AdvisorMessage;
import fish.payara.advisor.AdvisorType;
import java.io.File;
import java.util.Objects;

public class AdvisorBean {
    private File file;
    private String methodDeclaration;
    private String importDeclaration;
    private String annotationDeclaration;
    private String line;
    private String keyPattern;
    private String valuePattern;
    private AdvisorMessage advisorMessage;
    private AdvisorType type;

    private AdvisorBean(AdvisorBeanBuilder advisorBeanBuilder) {
        this.file = advisorBeanBuilder.file;
        this.methodDeclaration = advisorBeanBuilder.methodDeclaration;
        this.importDeclaration = advisorBeanBuilder.importDeclaration;
        this.line = advisorBeanBuilder.line;
        this.keyPattern = advisorBeanBuilder.keyPattern;
        this.valuePattern = advisorBeanBuilder.valuePattern;
        this.advisorMessage = advisorBeanBuilder.advisorMessage;
        this.annotationDeclaration = advisorBeanBuilder.annotationDeclaration;
        this.type = advisorBeanBuilder.type;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof AdvisorBean) {
            AdvisorBean other = (AdvisorBean)obj;
            return this.file.equals(other.file) && this.line.equals(other.line) && this.valuePattern.equals(other.valuePattern);
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getMethodDeclaration() {
        return this.methodDeclaration;
    }

    public void setMethodDeclaration(String methodDeclaration) {
        this.methodDeclaration = methodDeclaration;
    }

    public String getImportDeclaration() {
        return this.importDeclaration;
    }

    public void setImportDeclaration(String importDeclaration) {
        this.importDeclaration = importDeclaration;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getKeyPattern() {
        return this.keyPattern;
    }

    public void setKeyPattern(String keyPattern) {
        this.keyPattern = keyPattern;
    }

    public String getValuePattern() {
        return this.valuePattern;
    }

    public void setValuePattern(String valuePattern) {
        this.valuePattern = valuePattern;
    }

    public AdvisorMessage getAdvisorMessage() {
        return this.advisorMessage;
    }

    public void setAdvisorMessage(AdvisorMessage advisorMessage) {
        this.advisorMessage = advisorMessage;
    }

    public String getAnnotationDeclaration() {
        return this.annotationDeclaration;
    }

    public void setAnnotationDeclaration(String annotationDeclaration) {
        this.annotationDeclaration = annotationDeclaration;
    }

    public AdvisorType getType() {
        return this.type;
    }

    public void setType(AdvisorType type) {
        this.type = type;
    }

    public String toString() {
        return "Line of code: " + (this.line == null ? "-" : this.line) + " | Expression: " + this.getExpression() + "\nSource file: " + (this.file == null ? "-" : this.file.getName()) + "\n" + this.advisorMessage.toString();
    }

    private String getExpression() {
        if (this.methodDeclaration != null) {
            return this.methodDeclaration;
        }
        if (this.annotationDeclaration != null) {
            return this.annotationDeclaration;
        }
        return Objects.requireNonNullElse(this.importDeclaration, "");
    }

    public static class AdvisorBeanBuilder {
        private File file;
        private String methodDeclaration;
        private String importDeclaration;
        private String annotationDeclaration;
        private String line;
        private final String keyPattern;
        private final String valuePattern;
        private AdvisorMessage advisorMessage;
        private AdvisorType type;

        public AdvisorBeanBuilder(String keyPattern, String valuePattern) {
            this.keyPattern = keyPattern;
            this.valuePattern = valuePattern;
        }

        public AdvisorBeanBuilder setFile(File file) {
            this.file = file;
            return this;
        }

        public AdvisorBeanBuilder setMethodDeclaration(String methodDeclaration) {
            this.methodDeclaration = methodDeclaration;
            return this;
        }

        public AdvisorBeanBuilder setImportDeclaration(String importDeclaration) {
            this.importDeclaration = importDeclaration;
            return this;
        }

        public AdvisorBeanBuilder setLine(String line) {
            this.line = line;
            return this;
        }

        public AdvisorBeanBuilder setAdvisorMessage(AdvisorMessage advisorMessage) {
            this.advisorMessage = advisorMessage;
            return this;
        }

        public AdvisorBeanBuilder setAnnotationDeclaration(String annotationDeclaration) {
            this.annotationDeclaration = annotationDeclaration;
            return this;
        }

        public AdvisorBeanBuilder setType(AdvisorType type) {
            this.type = type;
            return this;
        }

        public AdvisorBean build() {
            return new AdvisorBean(this);
        }
    }
}

