/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import fish.payara.advisor.AdvisorBean;
import fish.payara.advisor.AdvisorInterface;
import fish.payara.advisor.AdvisorMethodCall;
import java.util.List;
import java.util.Optional;

public class AdvisorConstructorCall
extends AdvisorMethodCall
implements AdvisorInterface {
    @Override
    public VoidVisitor<List<AdvisorBean>> createVoidVisitor(String keyPattern, String valuePattern, String ... params) {
        return new ConstructorCallCollector(keyPattern, valuePattern, params);
    }

    @Override
    public VoidVisitor<List<AdvisorBean>> createVoidVisitor(String keyPattern, String valuePattern, String secondPattern) {
        return null;
    }

    private static class ConstructorCallCollector
    extends VoidVisitorAdapter<List<AdvisorBean>> {
        private final String keyPattern;
        private final String valuePattern;
        private final String[] params;

        public ConstructorCallCollector(String keyPattern, String valuePattern, String ... params) {
            this.keyPattern = keyPattern;
            this.valuePattern = valuePattern;
            this.params = params;
        }

        public void visit(ObjectCreationExpr objectCreationExpr, List<AdvisorBean> advisorBeans) {
            super.visit(objectCreationExpr, advisorBeans);
            Optional p = objectCreationExpr.getBegin();
            if (objectCreationExpr.isObjectCreationExpr() && objectCreationExpr.toString().contains(this.valuePattern)) {
                if (this.params.length == 0) {
                    AdvisorBean advisorMethodBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, this.valuePattern).setLine(p.map(position -> "" + position.line).orElse("")).setMethodDeclaration(objectCreationExpr.toString()).build();
                    advisorBeans.add(advisorMethodBean);
                } else if (AdvisorMethodCall.isSameArgumentTypes(this.params, (NodeList<Expression>)objectCreationExpr.getArguments())) {
                    AdvisorBean advisorMethodBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, this.valuePattern).setLine(p.map(position -> "" + position.line).orElse("")).setMethodDeclaration(objectCreationExpr.toString()).build();
                    advisorBeans.add(advisorMethodBean);
                }
            }
        }

        public void visit(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt, List<AdvisorBean> advisorBeans) {
            super.visit(explicitConstructorInvocationStmt, advisorBeans);
            Optional p = explicitConstructorInvocationStmt.getBegin();
            if (explicitConstructorInvocationStmt.isExplicitConstructorInvocationStmt() && this.params.length == 0) {
                AdvisorBean advisorMethodBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, this.valuePattern).setLine(p.map(position -> "" + position.line).orElse("")).setMethodDeclaration(explicitConstructorInvocationStmt.toString()).build();
                advisorBeans.add(advisorMethodBean);
            }
        }
    }
}

