/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import fish.payara.advisor.AdvisorAnnotationWithProperty;
import fish.payara.advisor.AdvisorBean;
import fish.payara.advisor.AdvisorClassImport;
import fish.payara.advisor.AdvisorConstructorCall;
import fish.payara.advisor.AdvisorFieldCall;
import fish.payara.advisor.AdvisorInterface;
import fish.payara.advisor.AdvisorMethodCall;
import fish.payara.advisor.AdvisorMethodDeclaration;
import fish.payara.advisor.Analyzer;
import fish.payara.advisor.config.files.BeansXml;
import fish.payara.advisor.config.files.JaxWsProperties;
import fish.payara.advisor.config.files.JaxmProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class AdvisorEvaluator {
    public List<AdvisorBean> adviseCode(Properties patterns, List<File> files) throws IOException {
        ArrayList<AdvisorBean> advisorsList = new ArrayList<AdvisorBean>();
        AdvisorInterface[] advisorInterfaces = new AdvisorInterface[]{new AdvisorMethodCall(), new AdvisorClassImport()};
        for (File sourceFile : files) {
            patterns.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String value = (String)v;
                if (value.contains("#")) {
                    this.processMethodCall(value, (String)k, sourceFile, advisorsList);
                } else if (value.contains("@")) {
                    this.processAnnotation(value, (String)k, sourceFile, advisorsList);
                } else {
                    for (AdvisorInterface advisorInterface : advisorInterfaces) {
                        AdvisorBean advisorBean = null;
                        try {
                            advisorBean = advisorInterface.parseFile((String)k, (String)v, sourceFile, new String[0]);
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        if (advisorBean == null || advisorsList.contains(advisorBean)) continue;
                        advisorsList.add(advisorBean);
                    }
                }
            }));
        }
        return advisorsList;
    }

    private void processMethodCall(String value, String key, File sourceFile, List<AdvisorBean> advisorsList) {
        String importNameSpace = value.substring(0, value.indexOf("#"));
        String methodCall = value.substring(value.indexOf("#") + 1, value.length());
        AdvisorBean advisorBean = null;
        AdvisorClassImport acimp = new AdvisorClassImport();
        try {
            advisorBean = acimp.parseFile(key, importNameSpace, sourceFile, new String[0]);
            if (advisorBean != null) {
                AdvisorMethodCall amc = new AdvisorMethodCall();
                String args = "";
                if (methodCall.contains("(") && methodCall.contains(")")) {
                    args = methodCall.substring(methodCall.indexOf(40) + 1, methodCall.indexOf(41));
                }
                if (methodCall.contains("constructor")) {
                    AdvisorConstructorCall acc = new AdvisorConstructorCall();
                    String constructorClass = importNameSpace.substring(importNameSpace.lastIndexOf(".") + 1);
                    advisorBean = args.length() > 0 ? (args.indexOf(44) > -1 ? acc.parseFile(key, constructorClass, sourceFile, args.split(",")) : acc.parseFile(key, constructorClass, sourceFile, args)) : acc.parseFile(key, constructorClass, sourceFile, new String[0]);
                } else if (methodCall.contains("constant")) {
                    AdvisorFieldCall afc = new AdvisorFieldCall();
                    String constantName = methodCall.substring(9, methodCall.length());
                    advisorBean = afc.parseFile(key, constantName, sourceFile, args);
                } else {
                    advisorBean = methodCall.contains("(") && methodCall.contains(")") ? (args.indexOf(44) > -1 ? amc.parseFile(key, methodCall, sourceFile, args.split(",")) : amc.parseFile(key, methodCall, sourceFile, args)) : amc.parseFile(key, methodCall, sourceFile, new String[0]);
                }
                if (advisorBean != null && !advisorsList.contains(advisorBean)) {
                    advisorsList.add(advisorBean);
                } else {
                    AdvisorMethodDeclaration amd = new AdvisorMethodDeclaration();
                    advisorBean = amd.parseFile(key, methodCall, sourceFile, new String[0]);
                    if (advisorBean != null && !advisorsList.contains(advisorBean)) {
                        advisorsList.add(advisorBean);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void processAnnotation(String value, String key, File sourceFile, List<AdvisorBean> advisorsList) {
        String importAnnotationNameSpace = value.substring(0, value.indexOf("@"));
        String annotationPropertyDeclaration = value.substring(value.indexOf("@") + 1, value.length());
        AdvisorBean advisorBean = null;
        AdvisorClassImport acimp = new AdvisorClassImport();
        try {
            AdvisorAnnotationWithProperty aacwp;
            advisorBean = acimp.parseFile(key, importAnnotationNameSpace, sourceFile, new String[0]);
            if (advisorBean != null && (advisorBean = (aacwp = new AdvisorAnnotationWithProperty()).parseFile(key, importAnnotationNameSpace, annotationPropertyDeclaration, sourceFile)) != null && !advisorsList.contains(advisorBean)) {
                advisorsList.add(advisorBean);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void adviseJspandJSFFiles(Properties patterns, List<AdvisorBean> advisorBeans, List<File> files) {
        Set namespaceProperties = patterns.entrySet().stream().filter(entry -> entry.getKey().toString().contains("namespace-upgrade")).collect(Collectors.toSet());
        Set deprecatedTags = patterns.entrySet().stream().filter(entry -> entry.getKey().toString().contains("tag-deprecated")).collect(Collectors.toSet());
        for (File sourceFile : files) {
            if (!sourceFile.exists() || !sourceFile.isFile()) continue;
            try {
                List<String> allLines = Files.readAllLines(Paths.get(sourceFile.toURI()));
                namespaceProperties.stream().forEach(entry -> {
                    String valuePattern = (String)entry.getValue();
                    String key = (String)entry.getKey();
                    Optional<String> result = allLines.stream().filter(s -> s.contains(valuePattern)).findAny();
                    if (result.isPresent()) {
                        AdvisorBean advisorBean = new AdvisorBean.AdvisorBeanBuilder(key, valuePattern).setFile(sourceFile).setMethodDeclaration("namespace:" + valuePattern + " was replaced").build();
                        advisorBeans.add(advisorBean);
                    }
                });
                deprecatedTags.stream().forEach(entry -> {
                    Optional<String> result;
                    String valuePattern = (String)entry.getValue();
                    String key = (String)entry.getKey();
                    Optional<String> optional = result = valuePattern.contains("#") ? allLines.stream().filter(s -> s.contains(valuePattern.split("#")[0]) && s.contains(valuePattern.split("#")[1])).findAny() : allLines.stream().filter(s -> s.contains(valuePattern)).findAny();
                    if (result.isPresent()) {
                        AdvisorBean advisorBean = new AdvisorBean.AdvisorBeanBuilder(key, valuePattern).setFile(sourceFile).setMethodDeclaration(valuePattern + " was deprecated").build();
                        advisorBeans.add(advisorBean);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void adviseConfigFiles(List<AdvisorBean> advisorBeans, List<File> files) {
        boolean beanXmlNotFound = true;
        for (File file : files) {
            Object advisorsFromAnalyzer;
            Analyzer<List<AdvisorBean>> beanAnalyzer;
            if (!file.isFile()) continue;
            if ("beans.xml".equals(file.getName())) {
                beanAnalyzer = new BeansXml();
                beanXmlNotFound = false;
                advisorsFromAnalyzer = beanAnalyzer.analise(file);
                if (advisorsFromAnalyzer.size() <= 0) continue;
                advisorBeans.addAll((Collection<AdvisorBean>)advisorsFromAnalyzer);
                continue;
            }
            if ("jaxws.properties".equals(file.getName())) {
                beanAnalyzer = new JaxWsProperties();
                advisorsFromAnalyzer = beanAnalyzer.analise(file);
                advisorBeans.addAll((Collection<AdvisorBean>)advisorsFromAnalyzer);
                continue;
            }
            if (!"jaxm.properties".equals(file.getName()) || advisorBeans.containsAll((Collection<?>)(advisorsFromAnalyzer = (beanAnalyzer = new JaxmProperties()).analise(file)))) continue;
            advisorBeans.addAll((Collection<AdvisorBean>)advisorsFromAnalyzer);
        }
        if (beanXmlNotFound) {
            AdvisorBean advisorFileBean = new AdvisorBean.AdvisorBeanBuilder("jakarta-cdi-file-not-found-beans-xml", "not.found.beans.xml").setMethodDeclaration("not found beans.xml").build();
            advisorBeans.add(advisorFileBean);
        }
    }
}

