/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import fish.payara.advisor.AdvisorToolMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AdvisorLoader {
    private static final Logger log = Logger.getLogger(AdvisorLoader.class.getName());

    public Properties loadPatterns(String version) throws URISyntaxException, IOException {
        if (AdvisorToolMojo.class.getClassLoader().getResource("config/jakarta" + version) == null) {
            log.severe(String.format("Not available configurations for the indicated version %s", version));
            return null;
        }
        URI uriBaseFolder = Objects.requireNonNull(AdvisorToolMojo.class.getClassLoader().getResource("config/jakarta" + version + "/mappedPatterns")).toURI();
        Properties readPatterns = new Properties();
        Path internalPath = null;
        if (uriBaseFolder.getScheme().equals("jar")) {
            FileSystem fileSystem = FileSystems.newFileSystem(uriBaseFolder, Collections.emptyMap());
            internalPath = fileSystem.getPath("config/jakarta" + version + "/mappedPatterns", new String[0]);
        } else {
            internalPath = Paths.get(uriBaseFolder);
        }
        Stream<Path> walk = Files.walk(internalPath, 1, new FileVisitOption[0]);
        Iterator it = walk.iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            if (!p.getFileName().toString().contains(".properties")) continue;
            InputStream stream = AdvisorToolMojo.class.getClassLoader().getResourceAsStream(p.toString());
            try {
                if (stream == null) {
                    File f = p.toFile();
                    FileInputStream fileInputStream = new FileInputStream(f);
                    readPatterns.load(fileInputStream);
                    continue;
                }
                readPatterns.load(stream);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return readPatterns;
    }

    public List<File> loadSourceFiles(File baseDir) throws IOException {
        List<File> javaFiles = new ArrayList<File>();
        if (baseDir != null) {
            javaFiles = Files.walk(Paths.get(baseDir.toURI()), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".java")).filter(p -> !p.toString().contains(File.separator + "target" + File.separator)).map(Path::toFile).collect(Collectors.toList());
        }
        return javaFiles;
    }

    public List<File> loadJSPandJSFFiles(File baseDir) throws IOException {
        List<File> jspFiles = new ArrayList<File>();
        if (baseDir != null) {
            jspFiles = Files.walk(Paths.get(baseDir.toURI()), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".jsp") || p.toString().endsWith(".xhtml")).filter(p -> !p.toString().contains(File.separator + "target" + File.separator)).map(Path::toFile).collect(Collectors.toList());
        }
        return jspFiles;
    }

    public List<File> loadConfigFiles(File baseDir) throws IOException {
        List<File> configFiles = new ArrayList<File>();
        if (baseDir != null) {
            configFiles = Files.walk(Paths.get(baseDir.toURI()), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".xml") || p.toString().endsWith(".properties")).filter(p -> !p.toString().contains(File.separator + "target" + File.separator)).map(Path::toFile).collect(Collectors.toList());
        }
        return configFiles;
    }
}

