/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import fish.payara.advisor.AdvisorType;

public class AdvisorMessage {
    public static final String YELLOW = "\u001b[0;33m";
    public static final String GREEN = "\u001b[0;32m";
    public static final String RED = "\u001b[0;31m";
    public static final String BLUE = "\u001b[0;34m";
    public static final String RESET = "\u001b[0m";
    private String message;
    private String fix;
    private AdvisorType type;

    private AdvisorMessage(AdvisorMessageBuilder advisorMessageBuilder) {
        this.message = advisorMessageBuilder.message;
        this.fix = advisorMessageBuilder.fix;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getFix() {
        return this.fix;
    }

    public void setFix(String fix) {
        this.fix = fix;
    }

    public AdvisorType getType() {
        return this.type;
    }

    public void setType(AdvisorType type) {
        this.type = type;
    }

    public String toString() {
        if (this.getType() != null) {
            switch (this.getType()) {
                case INFO: {
                    return GREEN + this.message + "\u001b[0m\n\u001b[0;34m" + this.fix + RESET;
                }
                case WARN: {
                    return YELLOW + this.message + "\u001b[0m\n\u001b[0;34m" + this.fix + RESET;
                }
                case ERROR: {
                    return RED + this.message + "\u001b[0m\n\u001b[0;34m" + this.fix + RESET;
                }
            }
        }
        return "";
    }

    public static class AdvisorMessageBuilder {
        private String message;
        private String fix;

        public AdvisorMessageBuilder setMessage(String message) {
            this.message = message;
            return this;
        }

        public AdvisorMessageBuilder setFix(String fix) {
            this.fix = fix;
            return this;
        }

        public AdvisorMessage build() {
            return new AdvisorMessage(this);
        }
    }
}

