/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import fish.payara.advisor.AdvisorBean;
import fish.payara.advisor.AdvisorMessage;
import fish.payara.advisor.AdvisorToolMojo;
import fish.payara.advisor.AdvisorType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;

public class AdvisorMessageProcessor {
    public void updateLogSeverityForMessages(List<AdvisorBean> advisorMethodBeanList) {
        advisorMethodBeanList.forEach(b -> {
            String logSeverity;
            String string = b.getKeyPattern().contains("info") ? "info" : (b.getKeyPattern().contains("warn") ? "warn" : (logSeverity = b.getKeyPattern().contains("error") ? "error" : ""));
            if (!logSeverity.isEmpty()) {
                b.setType(AdvisorType.valueOf(logSeverity.toUpperCase()));
                b.setKeyPattern(b.getKeyPattern().substring(0, b.getKeyPattern().indexOf(logSeverity) - 1));
            }
        });
    }

    public void addMessages(List<AdvisorBean> advisorMethodBeanList, String adviseVersion) {
        this.addMessages("config/jakarta" + adviseVersion + "/advisorMessages", advisorMethodBeanList, "message");
        this.addMessages("config/jakarta" + adviseVersion + "/advisorFix", advisorMethodBeanList, "fix");
    }

    private void addMessages(String url, List<AdvisorBean> advisorMethodBeanList, String type) {
        advisorMethodBeanList.forEach(b -> {
            URI baseMessageFolder = null;
            try {
                baseMessageFolder = AdvisorToolMojo.class.getClassLoader().getResource(url).toURI();
                Path internalPath = null;
                if (baseMessageFolder.getScheme().equals("jar")) {
                    FileSystem fileSystem = FileSystems.getFileSystem(baseMessageFolder);
                    internalPath = fileSystem.getPath(url, new String[0]);
                } else {
                    internalPath = Paths.get(baseMessageFolder);
                }
                this.findMessage(internalPath, b.getKeyPattern(), type, (AdvisorBean)b);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void findMessage(Path internalPath, String keyPattern, String type, AdvisorBean b) throws IOException {
        String fileMessageName = null;
        String fileFix = null;
        String keyIssue = null;
        Properties messageProperties = new Properties();
        String subSpec = keyPattern.contains("method") ? "method" : (keyPattern.contains("remove") ? "remove" : (keyPattern.contains("file") ? "file" : (keyPattern.contains("namespace") ? "namespace" : "tag")));
        String spec = keyPattern.substring(0, keyPattern.indexOf(subSpec));
        if (type.equals("message")) {
            fileMessageName = spec + "messages.properties";
        }
        if (type.equals("fix")) {
            fileFix = spec + "fix-messages.properties";
        }
        if (keyPattern.contains("issue")) {
            keyIssue = spec + keyPattern.substring(keyPattern.indexOf("issue"));
        }
        if (internalPath != null) {
            Stream<Path> walk = Files.walk(internalPath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path p = (Path)it.next();
                if (type.equals("message") && p.getFileName().toString().contains(fileMessageName)) {
                    messageProperties = this.readProperties(messageProperties, p);
                }
                if (!type.equals("fix") || !p.getFileName().toString().contains(fileFix)) continue;
                messageProperties = this.readProperties(messageProperties, p);
            }
        }
        AdvisorMessage advisorMessage = null;
        advisorMessage = b.getAdvisorMessage() == null ? new AdvisorMessage.AdvisorMessageBuilder().build() : b.getAdvisorMessage();
        if (type.equals("message")) {
            String message = keyIssue != null ? messageProperties.getProperty(keyIssue) : messageProperties.getProperty(keyPattern);
            advisorMessage.setMessage(message);
        }
        if (type.equals("fix")) {
            String fix = keyIssue != null ? messageProperties.getProperty(keyIssue) : messageProperties.getProperty(keyPattern);
            advisorMessage.setFix(fix);
        }
        if (b.getType() != null) {
            advisorMessage.setType(b.getType());
        }
        b.setAdvisorMessage(advisorMessage);
    }

    private Properties readProperties(Properties messageProperties, Path p) throws IOException {
        try (InputStream stream = AdvisorToolMojo.class.getClassLoader().getResourceAsStream(p.toString());){
            if (stream == null) {
                File f = p.toFile();
                FileInputStream fileInputStream = new FileInputStream(f);
                messageProperties.load(fileInputStream);
            } else {
                messageProperties.load(stream);
            }
        }
        return messageProperties;
    }

    public void printToConsole(List<AdvisorBean> advisorMethodBeanList, Log log) {
        log.info((CharSequence)"Showing Advisories");
        log.info((CharSequence)"***************");
        advisorMethodBeanList.forEach(b -> {
            if (b.getType() != null) {
                switch (b.getType()) {
                    case INFO: {
                        log.info((CharSequence)b.toString());
                        break;
                    }
                    case WARN: {
                        log.warn((CharSequence)b.toString());
                        break;
                    }
                    case ERROR: {
                        log.error((CharSequence)b.toString());
                        break;
                    }
                }
            } else {
                log.info((CharSequence)b.toString());
            }
        });
    }
}

