/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import fish.payara.advisor.AdvisorBean;
import fish.payara.advisor.AdvisorInterface;
import java.util.List;
import java.util.Optional;

public class AdvisorMethodCall
implements AdvisorInterface {
    @Override
    public VoidVisitor<List<AdvisorBean>> createVoidVisitor(String keyPattern, String valuePattern, String ... params) {
        return new MethodCallCollector(keyPattern, valuePattern, params);
    }

    @Override
    public VoidVisitor<List<AdvisorBean>> createVoidVisitor(String keyPattern, String valuePattern, String secondPattern) {
        return null;
    }

    protected static boolean isSameArgumentTypes(String[] params, NodeList<Expression> nodeList) {
        if (nodeList.size() != params.length) {
            return false;
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ClassOrInterfaceType type;
            Expression argument = (Expression)nodeList.get(i);
            if (!(argument instanceof ObjectCreationExpr) || (type = ((ObjectCreationExpr)argument).getType()).getName().asString().equals(params[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean compareParameters(String[] params, NodeList<Parameter> nodeList) {
        if (nodeList.size() != params.length) {
            return false;
        }
        for (String param : params) {
            Optional<Parameter> optionalParameter = nodeList.stream().filter(n -> n.getType().toString().contains(param.trim())).findAny();
            if (optionalParameter.isPresent()) continue;
            return false;
        }
        return true;
    }

    private static class MethodCallCollector
    extends VoidVisitorAdapter<List<AdvisorBean>> {
        private final String keyPattern;
        private final String valuePattern;
        private final String[] params;

        public MethodCallCollector(String keyPattern, String valuePattern, String ... params) {
            this.keyPattern = keyPattern;
            this.valuePattern = valuePattern;
            this.params = params;
        }

        public void visit(MethodCallExpr methodCall, List<AdvisorBean> collector) {
            super.visit(methodCall, collector);
            Optional p = methodCall.getBegin();
            if (methodCall.toString().contains(this.valuePattern)) {
                AdvisorBean advisorMethodBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, this.valuePattern).setLine(p.map(position -> "" + position.line).orElse("")).setMethodDeclaration(methodCall.asMethodCallExpr().toString()).build();
                collector.add(advisorMethodBean);
            } else if (this.valuePattern.contains("(") && this.valuePattern.contains(")") && methodCall.toString().contains(this.valuePattern.substring(0, this.valuePattern.indexOf(40))) && AdvisorMethodCall.isSameArgumentTypes(this.params, (NodeList<Expression>)methodCall.getArguments())) {
                AdvisorBean advisorMethodBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, this.valuePattern).setLine(p.map(position -> "" + position.line).orElse("")).setMethodDeclaration(methodCall.asMethodCallExpr().toString()).build();
                collector.add(advisorMethodBean);
            }
        }

        public void visit(ClassExpr classExpr, List<AdvisorBean> collector) {
            super.visit(classExpr, collector);
            Optional p = classExpr.getBegin();
            if (classExpr.isClassExpr() && classExpr.toString().contains(this.valuePattern)) {
                AdvisorBean advisorMethodBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, this.valuePattern).setLine(p.map(position -> "" + position.line).orElse("")).setMethodDeclaration(classExpr.toString()).build();
                collector.add(advisorMethodBean);
            }
        }

        public void visit(MethodDeclaration methodDeclaration, List<AdvisorBean> collector) {
            super.visit(methodDeclaration, collector);
            Optional p = methodDeclaration.getBegin();
            if (methodDeclaration.isMethodDeclaration() && (this.params != null && this.params.length > 0 && AdvisorMethodCall.compareParameters(this.params, (NodeList<Parameter>)methodDeclaration.getParameters()) || methodDeclaration.getDeclarationAsString().contains(this.valuePattern))) {
                AdvisorBean advisorMethodBean = new AdvisorBean.AdvisorBeanBuilder(this.keyPattern, this.valuePattern).setLine(p.map(position -> "" + position.line).orElse("")).setMethodDeclaration(methodDeclaration.getDeclarationAsString()).build();
                collector.add(advisorMethodBean);
            }
        }
    }
}

