/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor;

import fish.payara.advisor.AdvisorBean;
import fish.payara.advisor.AdvisorEvaluator;
import fish.payara.advisor.AdvisorLoader;
import fish.payara.advisor.AdvisorMessageProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="advise", defaultPhase=LifecyclePhase.VERIFY)
public class AdvisorToolMojo
extends AbstractMojo {
    private static final Logger log = Logger.getLogger(AdvisorToolMojo.class.getName());
    private static final String ADVISE_VERSION = "adviseVersion";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="advisor-plugin.adviseVersion", defaultValue="10")
    private String adviseVersion;

    public void execute() {
        Properties patterns = null;
        List<AdvisorBean> advisorBeans = Collections.emptyList();
        Properties properties = System.getProperties();
        AdvisorLoader advisorLoader = new AdvisorLoader();
        AdvisorEvaluator advisorEvaluator = new AdvisorEvaluator();
        if (properties.getProperty(ADVISE_VERSION) != null) {
            this.adviseVersion = properties.getProperty(ADVISE_VERSION);
        }
        try {
            if (this.adviseVersion == null || this.adviseVersion.isEmpty()) {
                log.severe("You need to indicate adviseVersion option");
                return;
            }
            patterns = advisorLoader.loadPatterns(this.adviseVersion);
            List<File> files = advisorLoader.loadSourceFiles(this.project.getBasedir());
            if (!files.isEmpty() && patterns != null && !patterns.isEmpty()) {
                advisorBeans = advisorEvaluator.adviseCode(patterns, files);
            }
            if (!(files = advisorLoader.loadJSPandJSFFiles(this.project.getBasedir())).isEmpty()) {
                advisorEvaluator.adviseJspandJSFFiles(patterns, advisorBeans, files);
            }
            if (!(files = advisorLoader.loadConfigFiles(this.project.getBasedir())).isEmpty()) {
                advisorEvaluator.adviseConfigFiles(advisorBeans, files);
            }
            AdvisorMessageProcessor advisorMessageProcessor = new AdvisorMessageProcessor();
            advisorMessageProcessor.updateLogSeverityForMessages(advisorBeans);
            advisorMessageProcessor.addMessages(advisorBeans, this.adviseVersion);
            advisorMessageProcessor.printToConsole(advisorBeans, this.getLog());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAdviseVersion(String adviseVersion) {
        this.adviseVersion = adviseVersion;
    }

    public String getAdviseVersion() {
        return this.adviseVersion;
    }
}

