/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.advisor.config.files;

import fish.payara.advisor.AdvisorBean;
import fish.payara.advisor.Analyzer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansXml
implements Analyzer<List<AdvisorBean>> {
    @Override
    public List<AdvisorBean> analise(File file) {
        ArrayList<AdvisorBean> advisors = new ArrayList<AdvisorBean>();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
            BeanHandler handler = new BeanHandler();
            saxParser.parse(file, (DefaultHandler)handler);
            ArrayList<Bean> beans = handler.getBeans();
            if (beans.isEmpty()) {
                AdvisorBean advisorFileBean = new AdvisorBean.AdvisorBeanBuilder("jakarta-cdi-file-empty-beans-xml", "empty.beans.xml").setFile(file).setLine("0").setMethodDeclaration("empty beans.xml").build();
                advisors.add(advisorFileBean);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return advisors;
    }

    static class BeanHandler
    extends DefaultHandler {
        private final ArrayList<Bean> beans = new ArrayList();
        private Bean currentBean;

        public ArrayList<Bean> getBeans() {
            return this.beans;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("bean".equals(qName)) {
                String name = attributes.getValue("name");
                String className = attributes.getValue("class");
                this.currentBean = new Bean(name, className);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("bean".equals(qName)) {
                this.beans.add(this.currentBean);
                this.currentBean = null;
            }
        }
    }

    static class Bean {
        private final String name;
        private final String className;

        public Bean(String name, String className) {
            this.name = name;
            this.className = className;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

