/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.json;

import fish.payara.arquillian.shaded.glassfish.json.JsonArrayBuilderImpl;
import fish.payara.arquillian.shaded.glassfish.json.JsonNumberImpl;
import fish.payara.arquillian.shaded.glassfish.json.JsonObjectBuilderImpl;
import fish.payara.arquillian.shaded.glassfish.json.JsonStringImpl;
import fish.payara.arquillian.shaded.glassfish.json.api.BufferPool;
import fish.payara.arquillian.shaded.jakarta.json.JsonArrayBuilder;
import fish.payara.arquillian.shaded.jakarta.json.JsonObjectBuilder;
import fish.payara.arquillian.shaded.jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;

public final class MapUtil {
    private MapUtil() {
    }

    static JsonValue handle(Object value, BufferPool bufferPool) {
        if (value == null) {
            return JsonValue.NULL;
        }
        if (value instanceof JsonValue) {
            return (JsonValue)value;
        }
        if (value instanceof JsonArrayBuilder) {
            return ((JsonArrayBuilder)value).build();
        }
        if (value instanceof JsonObjectBuilder) {
            return ((JsonObjectBuilder)value).build();
        }
        if (value instanceof BigDecimal) {
            return JsonNumberImpl.getJsonNumber((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return JsonNumberImpl.getJsonNumber((BigInteger)value);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Double) {
            return JsonNumberImpl.getJsonNumber((Double)value);
        }
        if (value instanceof Integer) {
            return JsonNumberImpl.getJsonNumber((Integer)value);
        }
        if (value instanceof Long) {
            return JsonNumberImpl.getJsonNumber((Long)value);
        }
        if (value instanceof String) {
            return new JsonStringImpl((String)value);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            JsonArrayBuilderImpl jsonArrayBuilder = new JsonArrayBuilderImpl(collection, bufferPool);
            return jsonArrayBuilder.build();
        }
        if (value instanceof Map) {
            JsonObjectBuilderImpl object = new JsonObjectBuilderImpl((Map)value, bufferPool);
            return object.build();
        }
        throw new IllegalArgumentException(String.format("Type %s is not supported.", value.getClass()));
    }
}

