/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.managed;

import fish.payara.arquillian.container.payara.PayaraVersion;
import fish.payara.arquillian.container.payara.managed.PayaraMicroContainerConfiguration;
import fish.payara.arquillian.container.payara.process.BufferingConsumer;
import fish.payara.arquillian.container.payara.process.ConsoleReader;
import fish.payara.arquillian.container.payara.process.OutputLoggingConsumer;
import fish.payara.arquillian.container.payara.process.ProcessOutputConsumer;
import fish.payara.arquillian.container.payara.process.SilentOutputConsumer;
import fish.payara.arquillian.shaded.jakarta.json.Json;
import fish.payara.arquillian.shaded.jakarta.json.JsonArray;
import fish.payara.arquillian.shaded.jakarta.json.JsonObject;
import fish.payara.arquillian.shaded.jakarta.json.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class PayaraMicroDeployableContainer
implements DeployableContainer<PayaraMicroContainerConfiguration> {
    private static final Logger logger = Logger.getLogger(PayaraMicroDeployableContainer.class.getName());
    private static final Pattern instanceConfigPattern = Pattern.compile("Instance Configuration(?<jsonFormat>\")?.*Host\"?: \"?(?<host>.*?)\"?,{0,1}$.*HTTP Port\\(s\\)\"?: \"?(?<ports>.*?)\"?,?$.*HTTPS", 42);
    private static final Pattern jsonPattern = Pattern.compile("Deployed\": (?<jsonArray>\\[.+?\\])", 40);
    private static final Pattern appPattern = Pattern.compile("Deployed: (?<appName>.*) \\( (?<modules>.*) \\)");
    private static final Pattern modulePattern = Pattern.compile("(?<modName>.*?) (war) (?<modContextRoot>.*?) \\[ (?<servletMappings>.*?) \\]");
    private static final Pattern servletMappingsPattern = Pattern.compile("\\< (?<servletName>.*?) (?<servletMapping>.*?) \\>");
    private PayaraMicroContainerConfiguration configuration;
    private Process payaraMicroProcess;
    private Thread shutdownHook;
    private String log = "";

    public Class<PayaraMicroContainerConfiguration> getConfigurationClass() {
        return PayaraMicroContainerConfiguration.class;
    }

    public void setup(PayaraMicroContainerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration must not be null.");
        }
        this.configuration = configuration;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 5.0");
    }

    public void start() throws LifecycleException {
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("Archive must not be null.");
        }
        try {
            Path arquillianMicroDir = Files.createTempDirectory("arquillian-payara-micro", new FileAttribute[0]);
            Path deploymentDir = arquillianMicroDir.resolve("deployments/");
            deploymentDir.toFile().mkdir();
            File deploymentFile = deploymentDir.resolve(archive.getName()).toFile();
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deploymentFile);
            ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java", "-jar", this.configuration.getMicroJarFile().getAbsolutePath(), "--deploy", deploymentFile.getAbsolutePath()));
            if (this.configuration.isRandomHttpPort()) {
                cmd.addAll(Arrays.asList("--port", "" + (8080 + new SecureRandom().nextInt(1000))));
            }
            if (this.configuration.isAutoBindHttp()) {
                cmd.addAll(Arrays.asList("--autoBindHttp", "--autoBindRange", "1000"));
            }
            if (!this.configuration.isClusterEnabled()) {
                cmd.add("--nocluster");
            }
            if (this.configuration.getMicroVersion().isMoreRecentThan(new PayaraVersion("5.181-SNAPSHOT")) || this.configuration.isEnterprise()) {
                cmd.add("--showServletMappings");
            }
            if (this.configuration.isDebug()) {
                cmd.add(1, "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5006");
            }
            if (this.configuration.getCmdOptions() != null) {
                int index = 1;
                String[] stringArray = this.configuration.getCmdOptions().split("(?<!\\\\) ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String option = stringArray[i];
                    cmd.add(index, option.replace("\\ ", " "));
                    ++index;
                }
            }
            if (this.configuration.getExtraMicroOptions() != null) {
                for (String option : this.configuration.getExtraMicroOptions().split("(?<!\\\\) ")) {
                    cmd.add(option.replace("\\ ", " "));
                }
            }
            logger.info("Starting Payara Micro using cmd: " + cmd);
            this.registerShutdownHook();
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.environment();
            this.payaraMicroProcess = builder.redirectErrorStream(true).start();
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
            BufferingConsumer consumer = new BufferingConsumer(this.createProcessOutputConsumer());
            ConsoleReader logReader = new ConsoleReader(this.payaraMicroProcess, (ProcessOutputConsumer)consumer);
            executor.execute((Runnable)logReader);
            CountDownLatch payaraMicroStarted = new CountDownLatch(1);
            executor.scheduleAtFixedRate(() -> {
                this.log = consumer.getBuffer().toString();
                Matcher startupMatcher = instanceConfigPattern.matcher(this.log);
                if (startupMatcher.find()) {
                    payaraMicroStarted.countDown();
                }
            }, 1500L, 200L, TimeUnit.MILLISECONDS);
            int startupTimeoutInSeconds = this.configuration.isDebug() ? -1 : this.configuration.getStartupTimeoutInSeconds();
            boolean microStarted = false;
            if (startupTimeoutInSeconds == -1) {
                payaraMicroStarted.await();
                microStarted = true;
            } else {
                microStarted = payaraMicroStarted.await(startupTimeoutInSeconds, TimeUnit.SECONDS);
            }
            if (microStarted) {
                executor.shutdownNow();
                Matcher instanceConfigMatcher = instanceConfigPattern.matcher(this.log);
                if (instanceConfigMatcher.find()) {
                    String host = instanceConfigMatcher.group("host").trim();
                    String[] ports = instanceConfigMatcher.group("ports").trim().split(", ");
                    int firstPort = Integer.parseInt(ports[0].trim());
                    logger.info("Payara Micro running on host: " + host + " port: " + firstPort);
                    HTTPContext httpContext = new HTTPContext(host, firstPort);
                    if (instanceConfigMatcher.group("jsonFormat") != null) {
                        this.processDeploymentAsJson(this.log.substring(instanceConfigMatcher.start()), httpContext);
                    } else {
                        this.processDeploymentOldMethod(this.log.substring(instanceConfigMatcher.start()), httpContext);
                    }
                    ProtocolMetaData protocolMetaData = new ProtocolMetaData();
                    protocolMetaData.addContext((Object)httpContext);
                    return protocolMetaData;
                }
            }
        }
        catch (IOException e) {
            logger.severe("Failed in creating a thread for Payara Micro.\n" + e.getMessage());
            Thread.currentThread().interrupt();
            return null;
        }
        catch (InterruptedException e) {
            logger.severe("Timeout reached waiting for Payara Micro to start.\n" + e.getMessage());
            Thread.currentThread().interrupt();
            return null;
        }
        throw new DeploymentException("No applications were found deployed to Payara Micro.");
    }

    private void processDeploymentAsJson(String deploymentInformation, HTTPContext httpContext) {
        Matcher jsonMatcher = jsonPattern.matcher(deploymentInformation);
        if (jsonMatcher.find()) {
            String jsonString = jsonMatcher.group("jsonArray");
            try (JsonReader reader = Json.createReader(new StringReader(jsonString));){
                JsonArray array = reader.readArray();
                for (JsonObject app : array.getValuesAs(JsonObject.class)) {
                    this.printApplicationFound(app.getString("Name"));
                    HashMap<String, JsonObject> allMappings = new HashMap<String, JsonObject>();
                    JsonObject appMappings = app.getJsonObject("Mappings");
                    if (appMappings != null) {
                        String contextRoot = app.getString("Context Root");
                        allMappings.put(contextRoot, app.getJsonObject("Mappings"));
                    } else {
                        JsonArray modules = app.getJsonArray("Modules");
                        modules.forEach(moduleValue -> {
                            JsonObject module = (JsonObject)moduleValue;
                            String contextRoot = module.getString("Context Root");
                            this.printModuleFound(module.getString("Name"), contextRoot);
                            allMappings.put(contextRoot, module);
                        });
                    }
                    for (String contextRoot : allMappings.keySet()) {
                        JsonObject mappings = (JsonObject)allMappings.get(contextRoot);
                        mappings.values().forEach(name -> {
                            String servletName = name.toString().replaceAll("\"", "");
                            this.printServletFound(servletName);
                            httpContext.add(new Servlet(servletName, contextRoot));
                        });
                    }
                }
            }
        }
    }

    private void processDeploymentOldMethod(String deploymentInformation, HTTPContext httpContext) {
        Matcher appMatcher = appPattern.matcher(deploymentInformation);
        while (appMatcher.find()) {
            this.printApplicationFound(appMatcher.group("appName"));
            Matcher moduleMatcher = modulePattern.matcher(appMatcher.group("modules"));
            while (moduleMatcher.find()) {
                this.printModuleFound(moduleMatcher.group("modName"), moduleMatcher.group("modContextRoot"));
                Matcher servletMappingsMatcher = servletMappingsPattern.matcher(moduleMatcher.group("servletMappings"));
                while (servletMappingsMatcher.find()) {
                    this.printServletFound(servletMappingsMatcher.group("servletName"));
                    httpContext.add(new Servlet(servletMappingsMatcher.group("servletName"), moduleMatcher.group("modContextRoot")));
                }
            }
        }
    }

    private void printApplicationFound(String appName) {
        logger.log(Level.INFO, "Deployed application detected. Name: \"{0}\".", appName);
    }

    private void printModuleFound(String moduleName, String contextRoot) {
        logger.log(Level.INFO, "\tModule found. Name: \"{0}\". Context root: \"{1}\".", new Object[]{moduleName, contextRoot});
    }

    private void printServletFound(String servletName) {
        logger.log(Level.INFO, "\t\tServlet found. Name: \"{0}\".", servletName);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.removeShutdownHook();
        try {
            this.stopContainer();
        }
        catch (LifecycleException failedStoppingContainer) {
            logger.log(Level.SEVERE, "Failed stopping container.", failedStoppingContainer);
        }
    }

    public void stop() throws LifecycleException {
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private ProcessOutputConsumer createProcessOutputConsumer() {
        if (this.configuration.isOutputToConsole()) {
            return new OutputLoggingConsumer();
        }
        return new SilentOutputConsumer();
    }

    private void registerShutdownHook() {
        this.shutdownHook = new Thread(() -> {
            logger.warning("Forcing container shutdown");
            try {
                this.stopContainer();
            }
            catch (LifecycleException e) {
                logger.log(Level.SEVERE, "Failed stopping services through shutdown hook.", e);
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void stopContainer() throws LifecycleException {
        this.payaraMicroProcess.destroy();
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }
}

