/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.embedded;

import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebModule;
import fish.payara.arquillian.container.payara.embedded.PayaraConfiguration;
import fish.payara.arquillian.container.payara.embedded.ShrinkWrapUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.web.Context;
import org.glassfish.embeddable.web.WebContainer;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class PayaraContainer
implements DeployableContainer<PayaraConfiguration> {
    private static final Logger log = Logger.getLogger(PayaraContainer.class.getName());
    private static final String SYSTEM_PROPERTY_REGEX = "\\$\\{(.*)\\}";
    private static final String COMMAND_ADD_RESOURCES = "add-resources";
    private static final String ADDRESS = "localhost";
    private PayaraConfiguration configuration;
    private GlassFishRuntime glassfishRuntime;
    private GlassFish glassfish;
    private boolean shouldSetPort = true;
    private int bindHttpPort;
    private int bindHttpsPort;

    public Class<PayaraConfiguration> getConfigurationClass() {
        return PayaraConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 5.0");
    }

    public void setup(PayaraConfiguration configuration) {
        this.configuration = configuration;
        BootstrapProperties bootstrapProps = new BootstrapProperties();
        if (configuration.getInstallRoot() != null) {
            bootstrapProps.setInstallRoot(configuration.getInstallRoot());
        }
        try {
            this.glassfishRuntime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup GlassFish Embedded Bootstrap", e);
        }
        boolean cleanup = configuration.getCleanup();
        GlassFishProperties serverProps = new GlassFishProperties();
        if (configuration.getInstanceRoot() != null) {
            File instanceRoot = new File(configuration.getInstanceRoot());
            if (instanceRoot.exists()) {
                cleanup = false;
            }
            serverProps.setInstanceRoot(configuration.getInstanceRoot());
            this.shouldSetPort = false;
        }
        if (configuration.getConfigurationXml() != null) {
            serverProps.setConfigFileURI(configuration.getConfigurationXml());
            this.shouldSetPort = false;
        }
        serverProps.setConfigFileReadOnly(configuration.isConfigurationReadOnly());
        if (this.shouldSetPort) {
            this.bindHttpPort = configuration.getBindHttpPort();
            serverProps.setPort("http-listener", this.bindHttpPort);
            this.bindHttpsPort = configuration.getBindHttpsPort();
            serverProps.setPort("https-listener", this.bindHttpsPort);
        }
        try {
            this.glassfish = this.glassfishRuntime.newGlassFish(serverProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup GlassFish Embedded Runtime", e);
        }
        if (cleanup) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    PayaraContainer.this.deleteRecursive(new File(System.getProperty("com.sun.aas.instanceRoot")));
                }
            });
        }
    }

    public void start() throws LifecycleException {
        try {
            this.glassfish.start();
            if (!this.shouldSetPort) {
                this.readBindingHttpPort();
            }
            this.bindCommandRunner();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start GlassFish Embedded", (Throwable)e);
        }
        for (String resource : this.configuration.getResourcesXml()) {
            try {
                this.executeCommand(COMMAND_ADD_RESOURCES, resource);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not deploy sun-reosurces file: " + resource, e);
            }
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.unbindCommandRunner();
            this.glassfish.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop GlassFish Embedded", (Throwable)e);
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = this.createDeploymentName(archive.getName());
        try {
            this.glassfish.getDeployer().deploy(ShrinkWrapUtil.toURL(archive).toURI(), new String[]{"--name", deploymentName});
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + archive.getName(), (Throwable)e);
        }
        try {
            HTTPContext httpContext = new HTTPContext(ADDRESS, this.bindHttpPort);
            this.findServlets(httpContext, this.resolveWebArchiveNames(archive));
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (GlassFishException e) {
            throw new DeploymentException("Could not probe Payara embedded for environment", (Throwable)e);
        }
    }

    private String[] resolveWebArchiveNames(Archive<?> archive) {
        if (archive instanceof WebArchive) {
            return new String[]{this.createDeploymentName(archive.getName())};
        }
        if (archive instanceof EnterpriseArchive) {
            ArrayList<String> deploymentNames = new ArrayList<String>();
            for (ArchivePath path : archive.getContent(Filters.include((String)".*\\.war")).keySet()) {
                deploymentNames.add(this.createDeploymentName(path.get()));
            }
            return deploymentNames.toArray(new String[0]);
        }
        return new String[0];
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            this.glassfish.getDeployer().undeploy(this.createDeploymentName(archive.getName()), new String[0]);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private String createDeploymentName(String archiveName) {
        String correctedName = archiveName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.indexOf(".") != -1) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }

    public void findServlets(HTTPContext httpContext, String[] webArchiveNames) throws GlassFishException {
        WebContainer webContainer = (WebContainer)this.glassfish.getService(WebContainer.class);
        for (String deploymentName : webArchiveNames) {
            for (org.glassfish.embeddable.web.VirtualServer server : webContainer.getVirtualServers()) {
                Container child;
                WebModule webModule = null;
                for (Context context : server.getContexts()) {
                    if (!(context instanceof WebModule) || !((WebModule)context).getID().startsWith(deploymentName)) continue;
                    webModule = (WebModule)context;
                }
                if (webModule == null && server instanceof VirtualServer && (child = ((VirtualServer)server).findChild("/" + deploymentName)) instanceof WebModule) {
                    webModule = (WebModule)child;
                }
                if (webModule == null) continue;
                for (Map.Entry entry : webModule.getServletRegistrations().entrySet()) {
                    httpContext.add(new Servlet((String)entry.getKey(), webModule.getContextPath()));
                }
            }
        }
    }

    private String executeCommand(String command, String ... parameterList) throws Throwable {
        CommandRunner runner = this.glassfish.getCommandRunner();
        CommandResult result = runner.run(command, parameterList);
        String output = null;
        switch (result.getExitStatus()) {
            case FAILURE: 
            case WARNING: {
                throw result.getFailureCause();
            }
            case SUCCESS: {
                output = result.getOutput();
                log.log(Level.INFO, "command {0} parameters{1} result: {2}", new Object[]{command, parameterList, output});
            }
        }
        return output;
    }

    private void bindCommandRunner() throws NamingException, GlassFishException {
        new InitialContext().bind("org.glassfish.embeddable.CommandRunner", (Object)this.glassfish.getCommandRunner());
    }

    private void unbindCommandRunner() throws NamingException {
        new InitialContext().unbind("org.glassfish.embeddable.CommandRunner");
    }

    private void deleteRecursive(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("directory must be a directory");
        }
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteRecursive(file);
                    file.delete();
                    continue;
                }
                file.delete();
            }
            dir.delete();
        }
    }

    private void readBindingHttpPort() throws LifecycleException {
        String config = this.fetchAttribute("servers.server.server.config-ref");
        List<String> virtualServers = this.fetchAttributes("configs.config." + config + ".http-service.virtual-server.*.id");
        for (String virtualServer : virtualServers) {
            if (virtualServer.equals("__asadmin")) continue;
            String networkListenerList = this.fetchAttribute("configs.config." + config + ".http-service.virtual-server." + virtualServer + ".network-listeners");
            for (String networkListener : networkListenerList.split(",")) {
                Integer listenPort = this.readNetworkListenerPort(config, networkListener);
                if (listenPort == null) continue;
                this.bindHttpPort = listenPort;
            }
        }
    }

    private Integer readNetworkListenerPort(String config, String networkListener) throws LifecycleException {
        boolean enabled = Boolean.parseBoolean(this.fetchAttribute("configs.config." + config + ".network-config.network-listeners.network-listener." + networkListener + ".enabled"));
        if (enabled) {
            String protocol = this.fetchAttribute("configs.config." + config + ".network-config.network-listeners.network-listener." + networkListener + ".protocol");
            boolean securityEnabled = Boolean.parseBoolean(this.fetchAttribute("configs.config." + config + ".network-config.protocols.protocol." + protocol + ".security-enabled"));
            if (!securityEnabled) {
                String portNum = this.fetchAttribute("configs.config." + config + ".network-config.network-listeners.network-listener." + networkListener + ".port");
                Pattern sysProp = Pattern.compile(SYSTEM_PROPERTY_REGEX);
                Matcher matcher = sysProp.matcher(portNum);
                if (matcher.matches()) {
                    String propertyName = matcher.group(1);
                    portNum = this.fetchAttribute("configs.config." + config + ".system-property." + propertyName + ".value");
                    return Integer.parseInt(portNum);
                }
                return Integer.parseInt(portNum);
            }
        }
        return null;
    }

    private List<String> fetchAttributes(String ... parameterList) throws LifecycleException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            String[] lines = this.executeCommand("get", parameterList).split("\\n");
            for (int ctr = 1; ctr < lines.length; ++ctr) {
                result.add(lines[ctr].split("=")[1]);
            }
            return result;
        }
        catch (Throwable ex) {
            throw new LifecycleException("Failed to read the HTTP listener configuration.", ex);
        }
    }

    private String fetchAttribute(String ... parameterList) throws LifecycleException {
        try {
            return this.executeCommand("get", parameterList).split("\\n")[1].split("=")[1];
        }
        catch (Throwable ex) {
            throw new LifecycleException("Failed to read the HTTP listener configuration.", ex);
        }
    }
}

