/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.managed;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import java.io.File;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;

public class PayaraManagedContainerConfiguration
extends CommonPayaraConfiguration {
    private final String PAYARA_HOME_PROPERTY = "payara.home";
    private String payaraHome = System.getProperty("payara.home");
    private boolean outputToConsole = true;
    private boolean allowConnectingToRunningServer;
    private boolean enableH2;
    private String serverSystemProperties;

    public String getPayaraHome() {
        return this.payaraHome;
    }

    public void setPayaraHome(String payaraHome) {
        this.payaraHome = payaraHome;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public File getAdminCliJar() {
        return new File(this.getPayaraHome() + "/glassfish/modules/admin-cli.jar");
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }

    public boolean isEnableH2() {
        return this.enableH2;
    }

    public void setEnableH2(boolean enableH2) {
        this.enableH2 = enableH2;
    }

    public String getServerSystemProperties() {
        return this.serverSystemProperties;
    }

    public void setServerSystemProperties(String serverSystemProperties) {
        this.serverSystemProperties = serverSystemProperties;
    }

    public String getTarget() {
        return "server";
    }

    public void validate() throws ConfigurationException {
        Validate.notNull((Object)this.getPayaraHome(), (String)String.format("The arquillian.xml property payaraHome must be specified or the %s system property must be set", "payara.home"));
        Validate.configurationDirectoryExists((String)(this.getPayaraHome() + "/glassfish"), (String)(this.getPayaraHome() + " is not a valid GlassFish installation"));
        if (!this.getAdminCliJar().isFile()) {
            throw new IllegalArgumentException("Could not locate admin-cli.jar module in Payara installation: " + this.getPayaraHome());
        }
        if (this.getDomain() != null) {
            Validate.configurationDirectoryExists((String)(this.getPayaraHome() + "/glassfish/domains/" + this.getDomain()), (String)("Invalid domain: " + this.getDomain()));
        }
        super.validate();
    }
}

