/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.managed;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import fish.payara.arquillian.container.payara.CommonPayaraManager;
import fish.payara.arquillian.container.payara.managed.PayaraManagedContainerConfiguration;
import fish.payara.arquillian.container.payara.managed.PayaraServerControl;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class PayaraManagedDeployableContainer
implements DeployableContainer<PayaraManagedContainerConfiguration> {
    private PayaraManagedContainerConfiguration configuration;
    private PayaraServerControl payaraServerControl;
    private CommonPayaraManager<PayaraManagedContainerConfiguration> payaraManager;
    private boolean connectedToRunningServer;

    public Class<PayaraManagedContainerConfiguration> getConfigurationClass() {
        return PayaraManagedContainerConfiguration.class;
    }

    public void setup(PayaraManagedContainerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = configuration;
        this.payaraServerControl = new PayaraServerControl(configuration);
        this.payaraManager = new CommonPayaraManager((CommonPayaraConfiguration)configuration);
    }

    public void start() throws LifecycleException {
        if (this.payaraManager.isDASRunning()) {
            if (this.configuration.isAllowConnectingToRunningServer()) {
                this.connectedToRunningServer = true;
            } else {
                throw new LifecycleException("The server is already running! Managed containers do not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.connectedToRunningServer) {
            this.payaraServerControl.stop();
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 5.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            if (!this.connectedToRunningServer && !this.payaraManager.isDASRunning()) {
                this.payaraServerControl.start();
            }
            this.payaraManager.start();
        }
        catch (LifecycleException ex) {
            throw new DeploymentException("Cannot start Payara", (Throwable)ex);
        }
        return this.payaraManager.deploy(archive);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.payaraManager.undeploy(archive);
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

