/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.managed;

import fish.payara.arquillian.container.payara.managed.PayaraManagedContainerConfiguration;
import fish.payara.arquillian.container.payara.process.CloseableProcess;
import fish.payara.arquillian.container.payara.process.ConsoleReader;
import fish.payara.arquillian.container.payara.process.OutputLoggingConsumer;
import fish.payara.arquillian.container.payara.process.ProcessOutputConsumer;
import fish.payara.arquillian.container.payara.process.SilentOutputConsumer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;

class PayaraServerControl {
    private static final Logger logger = Logger.getLogger(PayaraServerControl.class.getName());
    private static final String JAVA_COMMAND_FILENAME = System.getProperty("os.name").toLowerCase().contains("win") ? "java.exe" : "java";
    private static final String H2_MISCONFIGURED_HINT = "It seems that the Payara version you are running might have a problem starting embedded H2 database. Please take a look at the server logs. You can also switch off 'enableH2' property in your 'arquillian.xml' if you don't need it.";
    private static final List<String> NO_ARGS = new ArrayList<String>();
    private final PayaraManagedContainerConfiguration config;
    private Thread shutdownHook;

    PayaraServerControl(PayaraManagedContainerConfiguration config) {
        this.config = config;
    }

    void start() throws LifecycleException {
        this.registerShutdownHook();
        if (this.config.isEnableH2()) {
            this.startH2Database();
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.config.isDebug()) {
            args.add("--debug");
        }
        this.executeAdminDomainCommand("Starting container", "start-domain", args, this.createProcessOutputConsumer());
        this.loadSystemProperties();
    }

    void loadSystemProperties() {
        String serverSystemProperties = null;
        Properties props = new Properties();
        try (InputStream istrm = Thread.currentThread().getContextClassLoader().getResourceAsStream("system-properties.properties");){
            if (istrm != null) {
                props.load(istrm);
            }
            if ((serverSystemProperties = props.stringPropertyNames().stream().map(key -> key + "=" + props.getProperty((String)key)).collect(Collectors.joining(":"))) != null && !serverSystemProperties.equals("")) {
                this.executeAdminCommand("create-system-properties from system-properties.properties", "create-system-properties", Collections.singletonList(serverSystemProperties), this.createProcessOutputConsumer());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating system properties from system-properties.properties: " + Thread.currentThread().getContextClassLoader().getResourceAsStream("system-properties.properties") + serverSystemProperties, t);
        }
        serverSystemProperties = this.config.getServerSystemProperties();
        if (serverSystemProperties != null && !serverSystemProperties.equals("")) {
            try {
                this.executeAdminCommand("create-system-properties from serverSystemProperties config", "create-system-properties", Collections.singletonList(serverSystemProperties), this.createProcessOutputConsumer());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error creating system properties from serverSystemProperties config: " + serverSystemProperties, t);
            }
        }
    }

    void stop() throws LifecycleException {
        this.removeShutdownHook();
        try {
            this.stopContainer();
        }
        catch (LifecycleException failedStoppingContainer) {
            logger.log(Level.SEVERE, "Failed stopping container.", failedStoppingContainer);
        }
        finally {
            this.stopH2Database();
        }
    }

    private void stopContainer() throws LifecycleException {
        this.executeAdminDomainCommand("Stopping container", "stop-domain", NO_ARGS, this.createProcessOutputConsumer());
    }

    private void startH2Database() throws LifecycleException {
        if (!this.config.isEnableH2()) {
            return;
        }
        try {
            this.executeAdminDomainCommand("Starting database", "start-database", NO_ARGS, this.createProcessOutputConsumer());
        }
        catch (LifecycleException e) {
            logger.warning(H2_MISCONFIGURED_HINT);
            throw e;
        }
    }

    private void stopH2Database() throws LifecycleException {
        if (this.config.isEnableH2()) {
            this.executeAdminDomainCommand("Stopping database", "stop-database", NO_ARGS, this.createProcessOutputConsumer());
        }
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    private void registerShutdownHook() {
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.warning("Forcing container shutdown");
                try {
                    PayaraServerControl.this.stopContainer();
                    PayaraServerControl.this.stopH2Database();
                }
                catch (LifecycleException e) {
                    logger.log(Level.SEVERE, "Failed stopping services through shutdown hook.", e);
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void executeAdminDomainCommand(String description, String adminCmd, List<String> args, ProcessOutputConsumer consumer) throws LifecycleException {
        if (this.config.getDomain() != null) {
            args.add(this.config.getDomain());
        }
        this.executeAdminCommand(description, adminCmd, args, consumer);
    }

    private void executeAdminCommand(String description, String command, List<String> args, ProcessOutputConsumer consumer) throws LifecycleException {
        int result;
        List<String> cmd = this.buildCommand(command, args);
        if (this.config.isOutputToConsole()) {
            System.out.println(description + " using command: " + cmd.toString());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.environment();
        try (CloseableProcess process = new CloseableProcess(processBuilder.redirectErrorStream(true).start());
             ConsoleReader consoleReader = new ConsoleReader((Process)process, consumer);){
            new Thread((Runnable)consoleReader).start();
            result = process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            logger.log(Level.SEVERE, description + (e instanceof IOException ? " failed." : " interrupted."), e);
            throw new LifecycleException("Unable to execute " + cmd.toString(), (Throwable)e);
        }
        if (result != 0) {
            throw new LifecycleException("Unable to execute " + cmd.toString());
        }
    }

    private List<String> buildCommand(String command, List<String> args) {
        ArrayList<String> cmd = new ArrayList<String>();
        File javaCmd = this.getJavaProgram();
        cmd.add(javaCmd == null ? "java" : javaCmd.getAbsolutePath());
        cmd.add("-jar");
        cmd.add(this.config.getAdminCliJar().getAbsolutePath());
        cmd.add(command);
        cmd.addAll(args);
        cmd.add("-t");
        return cmd;
    }

    private ProcessOutputConsumer createProcessOutputConsumer() {
        if (this.config.isOutputToConsole()) {
            return new OutputLoggingConsumer();
        }
        return new SilentOutputConsumer();
    }

    private File getJavaProgram() {
        File asJavaCommand = this.getJavaProgramFromEnv("AS_JAVA");
        if (asJavaCommand != null) {
            return asJavaCommand;
        }
        File javaHomeCommand = this.getJavaProgramFromEnv("JAVA_HOME");
        if (javaHomeCommand != null) {
            return javaHomeCommand;
        }
        return null;
    }

    private File getJavaProgramFromEnv(String key) {
        String property = System.getenv(key);
        if (property == null) {
            return null;
        }
        Path mainFolder = new File(property).toPath();
        File java = mainFolder.resolve("bin").resolve(JAVA_COMMAND_FILENAME).toFile();
        if (java.exists()) {
            return java;
        }
        return null;
    }
}

