/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import fish.payara.arquillian.container.payara.clientutils.PayaraClient;
import fish.payara.arquillian.container.payara.clientutils.PayaraClientException;
import fish.payara.arquillian.container.payara.clientutils.PayaraClientService;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class CommonPayaraManager<C extends CommonPayaraConfiguration> {
    private static final Logger log = Logger.getLogger(CommonPayaraManager.class.getName());
    private static final String DELETE_OPERATION = "__deleteoperation";
    private C configuration;
    private PayaraClient payaraClient;
    private String deploymentName;

    public CommonPayaraManager(C configuration) {
        this.configuration = configuration;
        this.payaraClient = new PayaraClientService((CommonPayaraConfiguration)configuration);
    }

    public void start() throws LifecycleException {
        try {
            this.payaraClient.startUp();
        }
        catch (PayaraClientException e) {
            log.severe(e.getMessage());
            throw new LifecycleException(e.getMessage());
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must not be null");
        }
        String archiveName = archive.getName();
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        try {
            InputStream deployment = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
            FormDataMultiPart form = new FormDataMultiPart();
            form.bodyPart((BodyPart)new StreamDataBodyPart("id", deployment, archiveName));
            this.deploymentName = this.createDeploymentName(archiveName);
            this.addDeployFormFields(this.deploymentName, form);
            HTTPContext httpContext = this.payaraClient.doDeploy(this.deploymentName, form);
            protocolMetaData.addContext((Object)httpContext);
        }
        catch (PayaraClientException e) {
            throw new DeploymentException("Could not deploy " + archiveName, (Throwable)e);
        }
        return protocolMetaData;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must not be null");
        }
        this.deploymentName = this.createDeploymentName(archive.getName());
        try {
            FormDataMultiPart form = new FormDataMultiPart();
            form.field("target", (Object)((CommonPayaraConfiguration)this.configuration).getTarget(), MediaType.TEXT_PLAIN_TYPE);
            form.field("operation", (Object)DELETE_OPERATION, MediaType.TEXT_PLAIN_TYPE);
            this.payaraClient.doUndeploy(this.deploymentName, form);
        }
        catch (PayaraClientException e) {
            throw new DeploymentException("Could not undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public boolean isDASRunning() {
        return this.payaraClient.isDASRunning();
    }

    private String createDeploymentName(String archiveName) {
        String correctedName = archiveName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.indexOf(".") != -1) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }

    private void addDeployFormFields(String name, FormDataMultiPart deployform) {
        deployform.field("name", (Object)name, MediaType.TEXT_PLAIN_TYPE);
        deployform.field("target", (Object)((CommonPayaraConfiguration)this.configuration).getTarget(), MediaType.TEXT_PLAIN_TYPE);
        if (((CommonPayaraConfiguration)this.configuration).getLibraries() != null) {
            deployform.field("libraries", (Object)((CommonPayaraConfiguration)this.configuration).getLibraries(), MediaType.TEXT_PLAIN_TYPE);
        }
        if (((CommonPayaraConfiguration)this.configuration).getProperties() != null) {
            deployform.field("properties", (Object)((CommonPayaraConfiguration)this.configuration).getProperties(), MediaType.TEXT_PLAIN_TYPE);
        }
        if (((CommonPayaraConfiguration)this.configuration).getType() != null && "osgi".equals(((CommonPayaraConfiguration)this.configuration).getType())) {
            deployform.field("type", (Object)((CommonPayaraConfiguration)this.configuration).getType(), MediaType.TEXT_PLAIN_TYPE);
        }
    }
}

