/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.clientutils;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import fish.payara.arquillian.container.payara.clientutils.PayaraClientException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ContainerException;

public class PayaraClientUtil {
    private static final Logger log = Logger.getLogger(PayaraClientUtil.class.getName());
    public static final String SUCCESS = "SUCCESS";
    public static final String WARNING = "WARNING";
    private final CommonPayaraConfiguration configuration;
    private final String adminBaseUrl;

    public PayaraClientUtil(CommonPayaraConfiguration configuration, String adminBaseUrl) {
        this.configuration = configuration;
        this.adminBaseUrl = adminBaseUrl;
    }

    public CommonPayaraConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getAttributes(String additionalResourceUrl) {
        Map<String, Object> extraProperties = this.getExtraProperties(this.GETRequest(additionalResourceUrl));
        if (extraProperties != null) {
            return (Map)extraProperties.get("entity");
        }
        return new HashMap<String, String>();
    }

    public Map<String, String> getChildResources(String additionalResourceUrl) {
        Map<String, Object> extraProperties = this.getExtraProperties(this.GETRequest(additionalResourceUrl));
        if (extraProperties != null) {
            return (Map)extraProperties.get("childResources");
        }
        return new HashMap<String, String>();
    }

    public Map<String, Object> GETRequest(String additionalResourceUrl) {
        return this.getResponseMap(this.prepareClient(additionalResourceUrl, new Class[0]).get());
    }

    public List<Map<String, Object>> getInstancesList(String additionalResourceUrl) throws ContainerException {
        Map<String, Object> extraProperties = this.getExtraProperties(this.GETRequest(additionalResourceUrl));
        if (extraProperties != null) {
            return this.getInstanceList(extraProperties);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public Map<String, String> getServerSystemProperties(String additionalResourceUrl) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        String message = this.getMessage(this.GETRequest(additionalResourceUrl));
        int systemPropertiesHeader = message.indexOf("List of System Properties for the Java Virtual Machine:");
        if (systemPropertiesHeader != -1) {
            String systemMessage = message.substring(systemPropertiesHeader + "List of System Properties for the Java Virtual Machine:".length());
            for (String line : systemMessage.split("(\\r\\n|\\r|\\n)")) {
                if (!line.contains("=")) continue;
                String[] keyValue = line.split("=");
                systemProperties.put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
        return systemProperties;
    }

    public Map<String, Object> getExtraProperties(Map<String, Object> responseMap) {
        return (Map)responseMap.get("extraProperties");
    }

    public String getMessage(Map<String, Object> responseMap) {
        return (String)responseMap.get("message");
    }

    private List<Map<String, Object>> getInstanceList(Map<String, Object> resultExtraProperties) {
        return (List)resultExtraProperties.get("instanceList");
    }

    public Map<String, Object> POSTMultiPartRequest(String additionalResourceUrl, FormDataMultiPart form) {
        return this.getResponseMap(this.prepareClient(additionalResourceUrl, MultiPartFeature.class).post(Entity.entity((Object)form, (MediaType)form.getMediaType())));
    }

    @SafeVarargs
    private final Invocation.Builder prepareClient(String additionalResourceUrl, Class<? extends Feature> ... features) {
        Client client = ClientBuilder.newClient();
        if (this.configuration.isAuthorisation()) {
            client.register((Object)HttpAuthenticationFeature.basic((String)this.configuration.getAdminUser(), (String)this.configuration.getAdminPassword()));
        }
        client.register((Object)new CsrfProtectionFilter());
        for (Class<? extends Feature> feature : features) {
            client.register(feature);
        }
        return client.target(this.adminBaseUrl + additionalResourceUrl).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("X-GlassFish-3", (Object)"ignore");
    }

    private Map<String, Object> getResponseMap(Response response) {
        Response.StatusType status;
        Map<Object, Object> responseMap = new HashMap();
        String message = "";
        String xmlDoc = (String)response.readEntity(String.class);
        if (xmlDoc != null && !xmlDoc.isEmpty()) {
            responseMap = this.xmlToMap(xmlDoc);
            message = "exit_code: " + responseMap.get("exit_code") + ", message: " + responseMap.get("message");
        }
        if ((status = response.getStatusInfo()).getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (responseMap.get("exit_code") == null) {
                throw new PayaraClientException(message);
            }
            if (WARNING.equals(responseMap.get("exit_code"))) {
                log.warning("Deployment resulted in a warning: " + message);
            } else if (!SUCCESS.equals(responseMap.get("exit_code"))) {
                throw new PayaraClientException(message);
            }
        } else if (status.getReasonPhrase() == "Not Found") {
            message = message + " [status: " + status.getFamily() + " reason: " + status.getReasonPhrase() + "]";
            log.warning(message);
        } else {
            message = message + " [status: " + status.getFamily() + " reason: " + status.getReasonPhrase() + "]";
            log.severe(message);
            throw new ContainerException(message);
        }
        return responseMap;
    }

    public Map<String, Object> xmlToMap(String document) {
        if (document == null) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isValidating", false);
        try (ByteArrayInputStream input = new ByteArrayInputStream(document.trim().getBytes("UTF-8"));){
            XMLStreamReader stream = factory.createXMLStreamReader(input);
            while (stream.hasNext()) {
                if (stream.next() != 1 || !"map".equals(stream.getLocalName())) continue;
                map = this.resolveXmlMap(stream);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        return map;
    }

    private Map<String, Object> resolveXmlMap(XMLStreamReader stream) throws XMLStreamException {
        boolean endMapFlag = false;
        HashMap<String, Object> entry = new HashMap<String, Object>();
        String key = null;
        String elementName = null;
        while (!endMapFlag) {
            int currentEvent = stream.next();
            if (currentEvent == 1) {
                if ("entry".equals(stream.getLocalName())) {
                    key = stream.getAttributeValue(null, "key");
                    String value = stream.getAttributeValue(null, "value");
                    if (value == null) continue;
                    entry.put(key, value);
                    key = null;
                    continue;
                }
                if ("map".equals(stream.getLocalName())) {
                    entry.put(key, this.resolveXmlMap(stream));
                    continue;
                }
                if ("list".equals(stream.getLocalName())) {
                    entry.put(key, this.resolveXmlList(stream));
                    continue;
                }
                elementName = stream.getLocalName();
                continue;
            }
            if (currentEvent == 2) {
                if ("map".equals(stream.getLocalName())) {
                    endMapFlag = true;
                }
                elementName = null;
                continue;
            }
            String document = stream.getText();
            if (elementName == null) continue;
            if ("number".equals(elementName)) {
                if (document.contains(".")) {
                    entry.put(key, Double.parseDouble(document));
                } else {
                    entry.put(key, Long.parseLong(document));
                }
            } else if ("string".equals(elementName)) {
                entry.put(key, document);
            }
            elementName = null;
        }
        return entry;
    }

    private List<Object> resolveXmlList(XMLStreamReader stream) throws XMLStreamException {
        boolean endListFlag = false;
        ArrayList<Object> list = new ArrayList<Object>();
        String elementName = null;
        while (!endListFlag) {
            int currentEvent = stream.next();
            if (currentEvent == 1) {
                if ("map".equals(stream.getLocalName())) {
                    list.add(this.resolveXmlMap(stream));
                    continue;
                }
                elementName = stream.getLocalName();
                continue;
            }
            if (currentEvent == 2) {
                if ("list".equals(stream.getLocalName())) {
                    endListFlag = true;
                }
                elementName = null;
                continue;
            }
            String document = stream.getText();
            if (elementName == null) continue;
            if ("number".equals(elementName)) {
                if (document.contains(".")) {
                    list.add(Double.parseDouble(document));
                } else {
                    list.add(Long.parseLong(document));
                }
            } else if ("string".equals(elementName)) {
                list.add(document);
            }
            elementName = null;
        }
        return list;
    }
}

